/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F32;
import java.text.DecimalFormat;
import java.util.Objects;
import org.ejml.UtilEjml;

public abstract class GeoTuple4D_F32<T extends GeoTuple4D_F32>
extends GeoTuple_F32<T> {
    public float x;
    public float y;
    public float z;
    public float w;

    protected GeoTuple4D_F32(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    protected GeoTuple4D_F32() {
    }

    @Override
    public int getDimension() {
        return 4;
    }

    protected void _setTo(GeoTuple4D_F32 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.w = a.w;
    }

    public void setTo(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public boolean isIdentical(float x, float y, float z, float w) {
        return this.x == x && this.y == y && this.z == z && this.w == w;
    }

    public boolean isIdentical(float x, float y, float z, float w, float tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol && Math.abs(this.z - z) <= tol && Math.abs(this.w - w) <= tol;
    }

    @Override
    public boolean isIdentical(GeoTuple4D_F32 t, float tol) {
        return Math.abs(this.x - t.x) <= tol && Math.abs(this.y - t.y) <= tol && Math.abs(this.z - t.z) <= tol && Math.abs(this.w - t.w) <= tol;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    @Override
    public float getIdx(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIdx(int index, float value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index " + index);
            }
        }
    }

    public void scale(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
    }

    public void plusIP(GeoTuple4D_F32 a) {
        this.x += a.x;
        this.y += a.y;
        this.z += a.z;
        this.w += a.w;
    }

    public T times(float scalar) {
        GeoTuple4D_F32 ret = (GeoTuple4D_F32)this.createNewInstance();
        ret.x = this.x * scalar;
        ret.y = this.y * scalar;
        ret.z = this.z * scalar;
        ret.w = this.w * scalar;
        return (T)ret;
    }

    public void timesIP(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
    }

    public void divideIP(float scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        this.w /= scalar;
    }

    public void normalize() {
        this.divideIP(this.norm());
    }

    @Override
    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    @Override
    public float normSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @Override
    public float distance(GeoTuple4D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        float dw = t.w - this.w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public float distance(float x, float y, float z, float w) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        float dw = this.w - w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    @Override
    public float distance2(GeoTuple4D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        float dw = t.w - this.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public float distance2(float x, float y, float z, float w) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        float dw = this.w - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public void print() {
        System.out.println(this);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z) || Float.isNaN(this.w);
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }

    public float maxAbs() {
        float absX = Math.abs(this.x);
        float absY = Math.abs(this.y);
        float absZ = Math.abs(this.z);
        float absW = Math.abs(this.w);
        float found = Math.max(absX, absY);
        if (found < absZ) {
            found = absZ;
        }
        if (found < absW) {
            found = absW;
        }
        return found;
    }

    @Override
    public void setTo(T src) {
        this.x = ((GeoTuple4D_F32)src).x;
        this.y = ((GeoTuple4D_F32)src).y;
        this.z = ((GeoTuple4D_F32)src).z;
        this.w = ((GeoTuple4D_F32)src).w;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoTuple4D_F32)) {
            return false;
        }
        GeoTuple4D_F32 o = (GeoTuple4D_F32)obj;
        return Float.compare(this.x, o.x) == 0 && Float.compare(this.y, o.y) == 0 && Float.compare(this.z, o.z) == 0 && Float.compare(this.w, o.w) == 0;
    }

    protected String toString(String name) {
        DecimalFormat format = new DecimalFormat("#");
        String sx = UtilEjml.fancyString(this.x, format, 11, 4);
        String sy = UtilEjml.fancyString(this.y, format, 11, 4);
        String sz = UtilEjml.fancyString(this.z, format, 11, 4);
        String sw = UtilEjml.fancyString(this.w, format, 11, 4);
        return name + "( " + sx + " " + sy + " " + sz + " " + sw + " )";
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }
}

