/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilEllipse_F64;
import georegression.geometry.UtilLine2D_F64;
import georegression.geometry.lines.IntersectionLinesGeneral_F64;
import georegression.geometry.polygon.AreaIntersectionPolygon2D_F64;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.RectangleLength2D_F64;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Intersection2D_F64 {
    public static boolean containsConvex(Polygon2D_F64 polygon, Point2D_F64 pt) {
        int N = polygon.size();
        boolean c = false;
        int i = 0;
        int j = N - 1;
        while (i < N) {
            Point2D_F64 a = ((Point2D_F64[])polygon.vertexes.data)[i];
            Point2D_F64 b = ((Point2D_F64[])polygon.vertexes.data)[j];
            if (a.y > pt.y != b.y > pt.y && pt.x < (b.x - a.x) * (pt.y - a.y) / (b.y - a.y) + a.x) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public static boolean containsConvex2(Polygon2D_F64 polygon, double x, double y) {
        int positive = 0;
        int negative = 0;
        int border = 0;
        int i = 0;
        int j = polygon.size() - 1;
        while (i < polygon.size()) {
            Point2D_F64 a = polygon.get(j);
            Point2D_F64 b = polygon.get(i);
            double ax = x - a.x;
            double by = y - b.y;
            double ay = y - a.y;
            double bx = x - b.x;
            double cross = ax * by - ay * bx;
            if (cross > 0.0) {
                ++positive;
            } else if (cross < 0.0) {
                ++negative;
            } else {
                ++border;
            }
            j = i++;
        }
        if (positive + border == polygon.size()) {
            return true;
        }
        return negative + border == polygon.size();
    }

    public static boolean containsConcave(Polygon2D_F64 polygon, Point2D_F64 pt) {
        int N = polygon.size();
        if (N <= 1) {
            return false;
        }
        int left = 0;
        int right = 0;
        for (int i = 0; i < N - 1; ++i) {
            double x;
            Point2D_F64 a = ((Point2D_F64[])polygon.vertexes.data)[i];
            Point2D_F64 b = ((Point2D_F64[])polygon.vertexes.data)[i + 1];
            if (!(pt.y >= a.y && pt.y < b.y) && (!(pt.y >= b.y) || !(pt.y < a.y))) continue;
            double d = x = b.y == a.y ? pt.x : (pt.y - a.y) * (b.x - a.x) / (b.y - a.y) + a.x;
            if (x <= pt.x) {
                ++left;
                continue;
            }
            if (!(x > pt.x)) continue;
            ++right;
        }
        Point2D_F64 a = ((Point2D_F64[])polygon.vertexes.data)[N - 1];
        Point2D_F64 b = ((Point2D_F64[])polygon.vertexes.data)[0];
        if (pt.y >= a.y && pt.y < b.y || pt.y >= b.y && pt.y < a.y) {
            double x;
            double d = x = b.y == a.y ? pt.x : (pt.y - a.y) * (b.x - a.x) / (b.y - a.y) + a.x;
            if (x <= pt.x) {
                ++left;
            } else if (x > pt.x) {
                ++right;
            }
        }
        return left % 2 == 1 && right % 2 == 1;
    }

    public static boolean contains(Quadrilateral_F64 quad, Point2D_F64 pt) {
        return Intersection2D_F64.containTriangle(quad.a, quad.b, quad.d, pt) || Intersection2D_F64.containTriangle(quad.b, quad.c, quad.d, pt);
    }

    public static boolean containTriangle(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, Point2D_F64 pt) {
        boolean ret = false;
        if (a.y > pt.y != b.y > pt.y && pt.x < (b.x - a.x) * (pt.y - a.y) / (b.y - a.y) + a.x) {
            ret = true;
        }
        if (b.y > pt.y != c.y > pt.y && pt.x < (c.x - b.x) * (pt.y - b.y) / (c.y - b.y) + b.x) {
            ret = !ret;
        }
        if (c.y > pt.y != a.y > pt.y && pt.x < (a.x - c.x) * (pt.y - c.y) / (a.y - c.y) + c.x) {
            ret = !ret;
        }
        return ret;
    }

    @Nullable
    public static Point2D_F64 intersection(LineParametric2D_F64 a, LineParametric2D_F64 b, @Nullable Point2D_F64 ret) {
        double t_b = a.getSlopeX() * (b.getY() - a.getY()) - a.getSlopeY() * (b.getX() - a.getX());
        double bottom = a.getSlopeY() * b.getSlopeX() - b.getSlopeY() * a.getSlopeX();
        if (bottom == 0.0) {
            return null;
        }
        double x = b.getSlopeX() * (t_b /= bottom) + b.getX();
        double y = b.getSlopeY() * t_b + b.getY();
        if (ret == null) {
            ret = new Point2D_F64();
        }
        ret.setTo(x, y);
        return ret;
    }

    @Nullable
    public static Point2D_F64 intersection(LineParametric2D_F64 a, LineParametric2D_F64 b, boolean ray, @Nullable Point2D_F64 ret) {
        if (!ray) {
            return Intersection2D_F64.intersection(a, b, ret);
        }
        double t_b = a.getSlopeX() * (b.getY() - a.getY()) - a.getSlopeY() * (b.getX() - a.getX());
        double bottom = a.getSlopeY() * b.getSlopeX() - b.getSlopeY() * a.getSlopeX();
        if (bottom == 0.0) {
            return null;
        }
        if ((t_b /= bottom) < 0.0) {
            return null;
        }
        double t_a = b.getSlopeX() * (a.getY() - b.getY()) - b.getSlopeY() * (a.getX() - b.getX());
        if ((t_a /= b.getSlopeY() * a.getSlopeX() - a.getSlopeY() * b.getSlopeX()) < 0.0) {
            return null;
        }
        if (ret == null) {
            ret = new Point2D_F64();
        }
        ret.x = b.getSlopeX() * t_b + b.getX();
        ret.y = b.getSlopeY() * t_b + b.getY();
        return ret;
    }

    public static double intersection(LineParametric2D_F64 a, LineParametric2D_F64 b) {
        double t_a = b.getSlopeX() * (a.getY() - b.getY()) - b.getSlopeY() * (a.getX() - b.getX());
        double bottom = b.getSlopeY() * a.getSlopeX() - a.getSlopeY() * b.getSlopeX();
        if (bottom == 0.0) {
            return Double.NaN;
        }
        return t_a / bottom;
    }

    @Nullable
    public static Point2D_F64 intersection(LineSegment2D_F64 l_0, LineSegment2D_F64 l_1, @Nullable Point2D_F64 ret) {
        double a0 = l_0.b.x - l_0.a.x;
        double b0 = l_0.b.y - l_0.a.y;
        double a1 = l_1.b.x - l_1.a.x;
        double b1 = l_1.b.y - l_1.a.y;
        double top = b0 * (l_1.a.x - l_0.a.x) + a0 * (l_0.a.y - l_1.a.y);
        double bottom = a0 * b1 - b0 * a1;
        if (bottom == 0.0) {
            return null;
        }
        double t_1 = top / bottom;
        if (t_1 < 0.0 || t_1 > 1.0) {
            return null;
        }
        top = b1 * (l_0.a.x - l_1.a.x) + a1 * (l_1.a.y - l_0.a.y);
        bottom = a1 * b0 - b1 * a0;
        double t_0 = top / bottom;
        if (t_0 < 0.0 || t_0 > 1.0) {
            return null;
        }
        if (ret == null) {
            ret = new Point2D_F64();
        }
        ret.setTo(l_1.a.x + a1 * t_1, l_1.a.y + b1 * t_1);
        return ret;
    }

    public static boolean intersects(LineSegment2D_F64 a, LineSegment2D_F64 b, double tol) {
        return Intersection2D_F64.intersects(a.a, a.b, b.a, b.b, tol);
    }

    public static boolean intersects(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, Point2D_F64 d, double tol) {
        if (UtilLine2D_F64.isColinear(a, b, c, tol) || UtilLine2D_F64.isColinear(a, b, d, tol) || UtilLine2D_F64.isColinear(c, d, a, tol) || UtilLine2D_F64.isColinear(c, d, b, tol)) {
            if (UtilLine2D_F64.isColinear(a, b, c, tol) && UtilLine2D_F64.isBetweenColinear(a, b, c)) {
                return true;
            }
            if (UtilLine2D_F64.isColinear(a, b, d, tol) && UtilLine2D_F64.isBetweenColinear(a, b, d)) {
                return true;
            }
            if (UtilLine2D_F64.isColinear(c, d, a, tol) && UtilLine2D_F64.isBetweenColinear(c, d, a)) {
                return true;
            }
            return UtilLine2D_F64.isColinear(c, d, b, tol) && UtilLine2D_F64.isBetweenColinear(c, d, b);
        }
        double abc = Math.signum(UtilLine2D_F64.area2(a, b, c));
        double abd = Math.signum(UtilLine2D_F64.area2(a, b, d));
        double cda = Math.signum(UtilLine2D_F64.area2(c, d, a));
        double cdb = Math.signum(UtilLine2D_F64.area2(c, d, b));
        return abc * abd < 0.0 && cda * cdb < 0.0;
    }

    public static boolean intersects2(LineSegment2D_F64 a, LineSegment2D_F64 b, double tol) {
        return Intersection2D_F64.intersects2(a.a, a.b, b.a, b.b, tol);
    }

    public static boolean intersects2(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, Point2D_F64 d, double tol) {
        if (UtilLine2D_F64.isColinear(a, b, c, tol) || UtilLine2D_F64.isColinear(a, b, d, tol) || UtilLine2D_F64.isColinear(c, d, a, tol) || UtilLine2D_F64.isColinear(c, d, b, tol)) {
            if (UtilLine2D_F64.isColinear(a, b, c, tol) && UtilLine2D_F64.isBetweenColinearExclusive(a, b, c)) {
                return true;
            }
            if (UtilLine2D_F64.isColinear(a, b, d, tol) && UtilLine2D_F64.isBetweenColinearExclusive(a, b, d)) {
                return true;
            }
            if (UtilLine2D_F64.isColinear(c, d, a, tol) && UtilLine2D_F64.isBetweenColinearExclusive(c, d, a)) {
                return true;
            }
            return UtilLine2D_F64.isColinear(c, d, b, tol) && UtilLine2D_F64.isBetweenColinearExclusive(c, d, b);
        }
        double abc = Math.signum(UtilLine2D_F64.area2(a, b, c));
        double abd = Math.signum(UtilLine2D_F64.area2(a, b, d));
        double cda = Math.signum(UtilLine2D_F64.area2(c, d, a));
        double cdb = Math.signum(UtilLine2D_F64.area2(c, d, b));
        return abc * abd < 0.0 && cda * cdb < 0.0;
    }

    public static Point3D_F64 intersection(LineGeneral2D_F64 a, LineGeneral2D_F64 b, @Nullable Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        ret.x = a.B * b.C - a.C * b.B;
        ret.y = a.C * b.A - a.A * b.C;
        ret.z = a.A * b.B - a.B * b.A;
        return ret;
    }

    public static Point3D_F64 intersection(List<LineGeneral2D_F64> lines, @Nullable Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        if (!new IntersectionLinesGeneral_F64().process(lines, ret)) {
            throw new RuntimeException("Solver failed. Is there NaN or infinities in the input?");
        }
        return ret;
    }

    @Nullable
    public static Point2D_F64 intersection(LineGeneral2D_F64 a, LineGeneral2D_F64 b, @Nullable Point2D_F64 ret) {
        if (ret == null) {
            ret = new Point2D_F64();
        }
        ret.x = a.B * b.C - a.C * b.B;
        ret.y = a.C * b.A - a.A * b.C;
        double z = a.A * b.B - a.B * b.A;
        if (z == 0.0) {
            return null;
        }
        ret.x /= z;
        ret.y /= z;
        return ret;
    }

    @Nullable
    public static Point2D_F64 intersection(Point2D_F64 lineA0, Point2D_F64 lineA1, Point2D_F64 lineB0, Point2D_F64 lineB1, @Nullable Point2D_F64 output) {
        if (output == null) {
            output = new Point2D_F64();
        }
        double slopeAx = lineA1.x - lineA0.x;
        double slopeAy = lineA1.y - lineA0.y;
        double slopeBx = lineB1.x - lineB0.x;
        double slopeBy = lineB1.y - lineB0.y;
        double top = slopeAy * (lineB0.x - lineA0.x) + slopeAx * (lineA0.y - lineB0.y);
        double bottom = slopeAx * slopeBy - slopeAy * slopeBx;
        if (bottom == 0.0) {
            return null;
        }
        double t = top / bottom;
        output.x = lineB0.x + t * slopeBx;
        output.y = lineB0.y + t * slopeBy;
        return output;
    }

    public static double intersection(LineParametric2D_F64 target, LineSegment2D_F64 l) {
        double a1 = l.b.x - l.a.x;
        double b1 = l.b.y - l.a.y;
        double top = target.slope.y * (l.a.x - target.p.x) + target.slope.x * (target.p.y - l.a.y);
        double bottom = target.slope.x * b1 - target.slope.y * a1;
        if (bottom == 0.0) {
            return Double.NaN;
        }
        double t_1 = top / bottom;
        if (t_1 < 0.0 || t_1 > 1.0) {
            return Double.NaN;
        }
        top = b1 * (target.p.x - l.a.x) + a1 * (l.a.y - target.p.y);
        bottom = a1 * target.slope.y - b1 * target.slope.x;
        return top / bottom;
    }

    public static double intersectionArea(Polygon2D_F64 a, Polygon2D_F64 b) {
        AreaIntersectionPolygon2D_F64 alg = new AreaIntersectionPolygon2D_F64();
        return Math.abs(alg.computeArea(a, b));
    }

    public static boolean contains(RectangleLength2D_F64 a, double x, double y) {
        if (a.getX() <= x && a.getX() + a.getWidth() > x) {
            return a.getY() <= y && a.getY() + a.getHeight() > y;
        }
        return false;
    }

    public static boolean contains2(RectangleLength2D_F64 a, double x, double y) {
        if (a.getX() <= x && a.getX() + a.getWidth() >= x) {
            return a.getY() <= y && a.getY() + a.getHeight() >= y;
        }
        return false;
    }

    public static boolean contains(Rectangle2D_F64 a, double x, double y) {
        return a.p0.x <= x && a.p1.x > x && a.p0.y <= y && a.p1.y > y;
    }

    public static boolean contains2(Rectangle2D_F64 a, double x, double y) {
        return a.p0.x <= x && a.p1.x >= x && a.p0.y <= y && a.p1.y >= y;
    }

    public static boolean contains(EllipseRotated_F64 ellipse, double x, double y) {
        return UtilEllipse_F64.evaluate(x, y, ellipse) <= 1.0;
    }

    @Nullable
    public static RectangleLength2D_F64 intersection(RectangleLength2D_F64 a, RectangleLength2D_F64 b) {
        double h;
        double tl_y;
        double w;
        double tl_x;
        if (a.getX() >= b.getX()) {
            if (a.getX() >= b.getX() + b.getWidth()) {
                return null;
            }
            tl_x = a.getX();
            w = b.getX() + b.getWidth() - a.getX();
        } else {
            if (a.getX() + a.getWidth() <= b.getX()) {
                return null;
            }
            tl_x = b.getX();
            w = a.getX() + a.getWidth() - b.getX();
        }
        if (a.getY() >= b.getY()) {
            if (a.getY() >= b.getY() + b.getHeight()) {
                return null;
            }
            tl_y = a.getY();
            h = b.getY() + b.getHeight() - a.getY();
        } else {
            if (a.getY() + a.getHeight() <= b.getY()) {
                return null;
            }
            tl_y = b.getY();
            h = a.getY() + a.getHeight() - b.getY();
        }
        return new RectangleLength2D_F64(tl_x, tl_y, w, h);
    }

    public static boolean intersects(Rectangle2D_F64 a, Rectangle2D_F64 b) {
        return a.p0.x < b.p1.x && a.p1.x > b.p0.x && a.p0.y < b.p1.y && a.p1.y > b.p0.y;
    }

    public static boolean intersection(Rectangle2D_F64 a, Rectangle2D_F64 b, Rectangle2D_F64 result) {
        if (!Intersection2D_F64.intersects(a, b)) {
            return false;
        }
        result.p0.x = Math.max(a.p0.x, b.p0.x);
        result.p1.x = Math.min(a.p1.x, b.p1.x);
        result.p0.y = Math.max(a.p0.y, b.p0.y);
        result.p1.y = Math.min(a.p1.y, b.p1.y);
        return true;
    }

    public static double intersectionArea(Rectangle2D_F64 a, Rectangle2D_F64 b) {
        if (!Intersection2D_F64.intersects(a, b)) {
            return 0.0;
        }
        double x0 = Math.max(a.p0.x, b.p0.x);
        double x1 = Math.min(a.p1.x, b.p1.x);
        double y0 = Math.max(a.p0.y, b.p0.y);
        double y1 = Math.min(a.p1.y, b.p1.y);
        return (x1 - x0) * (y1 - y0);
    }

    public static int intersection(LineGeneral2D_F64 line, EllipseRotated_F64 ellipse, Point2D_F64 intersection0, Point2D_F64 intersection1, double EPS) {
        double x1;
        double x0;
        double y1;
        double y0;
        int totalIntersections;
        if (EPS < 0.0) {
            EPS = GrlConstants.EPS;
        }
        double C = line.C + (line.A * ellipse.center.x + line.B * ellipse.center.y);
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        double A2 = line.A * cphi + line.B * sphi;
        double B = -line.A * sphi + line.B * cphi;
        double a2 = ellipse.a * ellipse.a;
        double b2 = ellipse.b * ellipse.b;
        if (Math.abs(A2) > Math.abs(B)) {
            double alpha = -C / A2;
            double beta = -B / A2;
            double bb = 2.0 * alpha * beta / a2;
            double aa = beta * beta / a2 + 1.0 / b2;
            double cc = alpha * alpha / a2 - 1.0;
            double inner = bb * bb - 4.0 * aa * cc;
            if (Math.abs(inner / aa) < EPS) {
                totalIntersections = 1;
                inner = inner < 0.0 ? 0.0 : inner;
            } else {
                if (inner < 0.0) {
                    return 0;
                }
                totalIntersections = 2;
            }
            double right = Math.sqrt(inner);
            y0 = (-bb + right) / (2.0 * aa);
            y1 = (-bb - right) / (2.0 * aa);
            x0 = -(C + B * y0) / A2;
            x1 = -(C + B * y1) / A2;
        } else {
            double alpha = -C / B;
            double beta = -A2 / B;
            double bb = 2.0 * alpha * beta / b2;
            double aa = beta * beta / b2 + 1.0 / a2;
            double cc = alpha * alpha / b2 - 1.0;
            double inner = bb * bb - 4.0 * aa * cc;
            if (Math.abs(inner / aa) < EPS) {
                totalIntersections = 1;
                inner = inner < 0.0 ? 0.0 : inner;
            } else {
                if (inner < 0.0) {
                    return 0;
                }
                totalIntersections = 2;
            }
            double right = Math.sqrt(inner);
            x0 = (-bb + right) / (2.0 * aa);
            x1 = (-bb - right) / (2.0 * aa);
            y0 = -(A2 * x0 + C) / B;
            y1 = -(A2 * x1 + C) / B;
        }
        intersection0.x = x0 * cphi - y0 * sphi + ellipse.center.x;
        intersection0.y = x0 * sphi + y0 * cphi + ellipse.center.y;
        intersection1.x = x1 * cphi - y1 * sphi + ellipse.center.x;
        intersection1.y = x1 * sphi + y1 * cphi + ellipse.center.y;
        return totalIntersections;
    }
}

