/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry.polygon;

import georegression.geometry.UtilLine2D_F32;
import georegression.geometry.UtilPolygons2D_F32;
import georegression.geometry.polygon.CyclicalLinkedList;
import georegression.geometry.polygon.ThreeIndexes;
import georegression.metric.Intersection2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogLinkedList;
import org.ejml.UtilEjml;

public class TriangulateSimpleRemoveEars_F32 {
    public float tol = UtilEjml.TEST_F32;
    public boolean knownOrder = false;
    public boolean ccw = true;
    protected final CyclicalLinkedList<Vertex> polygon = new CyclicalLinkedList();
    protected final DogArray<Vertex> vertexes = new DogArray<Vertex>(Vertex::new, Vertex::reset);

    public void process(Polygon2D_F32 input, DogArray<ThreeIndexes> output) {
        output.reset();
        if (input.size() < 3) {
            return;
        }
        if (input.size() == 3) {
            output.grow().set(0, 1, 2);
            return;
        }
        if (!this.knownOrder) {
            this.ccw = UtilPolygons2D_F32.isCCW(input);
        }
        this.convert(input, this.polygon);
        this.findEars();
        block0: while (this.polygon.size() > 3) {
            DogLinkedList.Element v2 = this.polygon.getHead();
            do {
                if (((Vertex)v2.object).ear) {
                    DogLinkedList.Element<Vertex> v3 = v2.next;
                    DogLinkedList.Element<Vertex> v4 = v2.next.next;
                    DogLinkedList.Element<Vertex> v1 = v2.prev;
                    DogLinkedList.Element<Vertex> v0 = v2.prev.prev;
                    ThreeIndexes tri = output.grow();
                    tri.idx0 = ((Vertex)v1.object).index;
                    tri.idx1 = ((Vertex)v2.object).index;
                    tri.idx2 = ((Vertex)v3.object).index;
                    this.polygon.remove(v2);
                    ((Vertex)v1.object).ear = this.isDiagonal(v0, v3);
                    ((Vertex)v3.object).ear = this.isDiagonal(v1, v4);
                    continue block0;
                }
                v2 = v2.next;
            } while (v2 != this.polygon.getHead());
        }
        DogLinkedList.Element e = this.polygon.getHead();
        ThreeIndexes tri = output.grow();
        tri.idx0 = ((Vertex)e.object).index;
        e = e.next;
        tri.idx1 = ((Vertex)e.object).index;
        e = e.next;
        tri.idx2 = ((Vertex)e.object).index;
    }

    void findEars() {
        DogLinkedList.Element e = this.polygon.getHead();
        do {
            ((Vertex)e.object).ear = this.isDiagonal(e.prev, e.next);
        } while ((e = e.next) != this.polygon.getHead());
    }

    boolean isDiagonal(DogLinkedList.Element<Vertex> a, DogLinkedList.Element<Vertex> b) {
        return this.isInCone(a, b) && this.isInCone(b, a) && this.isDiagonalie(a, b);
    }

    boolean isDiagonalie(DogLinkedList.Element<Vertex> a, DogLinkedList.Element<Vertex> b) {
        DogLinkedList.Element c = this.polygon.getHead();
        do {
            DogLinkedList.Element c1 = c.next;
            if (c == a || c1 == a || c == b || c1 == b || !Intersection2D_F32.intersects((Point2D_F32)a.object, (Point2D_F32)b.object, (Point2D_F32)c.object, (Point2D_F32)c1.object, this.tol)) continue;
            return false;
        } while ((c = c.next) != this.polygon.getHead());
        return true;
    }

    boolean isInCone(DogLinkedList.Element<Vertex> a, DogLinkedList.Element<Vertex> b) {
        DogLinkedList.Element a1 = a.next;
        DogLinkedList.Element a0 = a.prev;
        if (this.isLeftOn((Vertex)a.object, (Vertex)a1.object, (Vertex)a0.object)) {
            return this.isLeft((Vertex)a.object, (Vertex)b.object, (Vertex)a0.object) && this.isLeft((Vertex)b.object, (Vertex)a.object, (Vertex)a1.object);
        }
        return !this.isLeftOn((Vertex)a.object, (Vertex)b.object, (Vertex)a1.object) || !this.isLeftOn((Vertex)b.object, (Vertex)a.object, (Vertex)a0.object);
    }

    boolean isLeft(Vertex a, Vertex b, Vertex c) {
        if (this.ccw) {
            return UtilLine2D_F32.area2(a, b, c) > 0.0f;
        }
        return UtilLine2D_F32.area2(a, b, c) < 0.0f;
    }

    boolean isLeftOn(Vertex a, Vertex b, Vertex c) {
        if (this.ccw) {
            return UtilLine2D_F32.area2(a, b, c) >= 0.0f;
        }
        return UtilLine2D_F32.area2(a, b, c) <= 0.0f;
    }

    void convert(Polygon2D_F32 input, DogLinkedList<Vertex> output) {
        output.reset();
        this.vertexes.resize(input.size());
        this.vertexes.reset();
        int i = 0;
        while (i < input.size()) {
            Point2D_F32 p = input.get(i);
            Vertex v = this.vertexes.grow();
            v.index = i++;
            v.setTo(p.x, p.y);
            this.polygon.pushTail(v);
        }
    }

    static class Vertex
    extends Point2D_F32 {
        public int index;
        public boolean ear;

        Vertex() {
        }

        public void reset() {
            this.index = -1;
            this.y = Float.NaN;
            this.x = Float.NaN;
            this.ear = false;
        }

        @Override
        public String toString() {
            return "Vertex{index=" + this.index + ", ear=" + this.ear + ", x=" + this.x + ", y=" + this.y + '}';
        }
    }
}

