/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UtilPoint4D_F64 {
    public static boolean isInfiniteH(Point4D_F64 p, double tol) {
        double n = Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        return Math.abs(p.w) <= n * tol;
    }

    public static List<Point4D_F64> randomN(Point4D_F64 center, double stdev, int num, Random rand) {
        ArrayList<Point4D_F64> ret = new ArrayList<Point4D_F64>();
        for (int i = 0; i < num; ++i) {
            Point4D_F64 p = new Point4D_F64();
            p.x = center.x + rand.nextGaussian() * stdev;
            p.y = center.y + rand.nextGaussian() * stdev;
            p.z = center.z + rand.nextGaussian() * stdev;
            p.w = center.w + rand.nextGaussian() * stdev;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point4D_F64> randomN(Point3D_F64 center, double w, double stdev, int num, Random rand) {
        ArrayList<Point4D_F64> ret = new ArrayList<Point4D_F64>();
        for (int i = 0; i < num; ++i) {
            Point4D_F64 p = new Point4D_F64();
            p.x = center.x + rand.nextGaussian() * stdev;
            p.y = center.y + rand.nextGaussian() * stdev;
            p.z = center.z + rand.nextGaussian() * stdev;
            p.w = w;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point4D_F64> random(double min, double max, int num, Random rand) {
        ArrayList<Point4D_F64> ret = new ArrayList<Point4D_F64>();
        double d = max - min;
        for (int i = 0; i < num; ++i) {
            Point4D_F64 p = new Point4D_F64();
            p.x = rand.nextDouble() * d + min;
            p.y = rand.nextDouble() * d + min;
            p.z = rand.nextDouble() * d + min;
            p.w = rand.nextDouble() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static Point3D_F64 h_to_e(Point4D_F64 p) {
        Point3D_F64 out = new Point3D_F64();
        UtilPoint4D_F64.h_to_e(p, out);
        return out;
    }

    public static void h_to_e(Point4D_F64 p, Point3D_F64 out) {
        out.x = p.x / p.w;
        out.y = p.y / p.w;
        out.z = p.z / p.w;
    }
}

