/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point2D_F64;
import georegression.struct.trig.Circle2D_F64;

public class UtilCircle2D_F64 {
    public static double evaluate(double x, double y, Circle2D_F64 circle) {
        return (x -= circle.center.x) * x + (y -= circle.center.y) * y - circle.radius * circle.radius;
    }

    public static boolean circle(Point2D_F64 x0, Point2D_F64 x1, Point2D_F64 x2, Circle2D_F64 circle) {
        double xa = (x0.x + x1.x) / 2.0;
        double ya = (x0.y + x1.y) / 2.0;
        double xb = (x1.x + x2.x) / 2.0;
        double yb = (x1.y + x2.y) / 2.0;
        double m2 = x0.x - x1.x;
        double n1 = x1.y - x2.y;
        double n2 = x2.x - x1.x;
        double m1 = x1.y - x0.y;
        double bottom = m2 * n1 - n2 * m1;
        if (bottom == 0.0) {
            return false;
        }
        double alpha = (-m2 * (xb - xa) + m1 * (yb - ya)) / bottom;
        circle.center.x = xb + n1 * alpha;
        circle.center.y = yb + n2 * alpha;
        circle.radius = circle.center.distance(x0);
        return true;
    }

    public static double circleRadiusSq(Point2D_F64 x0, Point2D_F64 x1, Point2D_F64 x2) {
        double xa = (x0.x + x1.x) / 2.0;
        double ya = (x0.y + x1.y) / 2.0;
        double xb = (x1.x + x2.x) / 2.0;
        double yb = (x1.y + x2.y) / 2.0;
        double m2 = x0.x - x1.x;
        double n1 = x1.y - x2.y;
        double n2 = x2.x - x1.x;
        double m1 = x1.y - x0.y;
        double bottom = m2 * n1 - n2 * m1;
        if (bottom == 0.0) {
            return Double.NaN;
        }
        double alpha = (-m2 * (xb - xa) + m1 * (yb - ya)) / bottom;
        double dx = xb + n1 * alpha - x0.x;
        double dy = yb + n2 * alpha - x0.y;
        return dx * dx + dy * dy;
    }
}

