/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.affine;

import georegression.fitting.MotionTransformPoint;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.factory.LinearSolverFactory_FDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class MotionAffinePoint2D_F32
implements MotionTransformPoint<Affine2D_F32, Point2D_F32> {
    private LinearSolverDense<FMatrixRMaj> solver;
    private FMatrixRMaj A;
    protected FMatrixRMaj x;
    private FMatrixRMaj y;
    Affine2D_F32 model = new Affine2D_F32();

    public MotionAffinePoint2D_F32() {
        this.solver = LinearSolverFactory_FDRM.leastSquares(100, 2);
        this.x = new FMatrixRMaj(3, 2);
        this.A = new FMatrixRMaj(0, 3);
        this.y = new FMatrixRMaj(0, 2);
    }

    @Override
    public Affine2D_F32 getTransformSrcToDst() {
        return this.model;
    }

    @Override
    public boolean process(List<Point2D_F32> srcPts, List<Point2D_F32> dstPts) {
        int i;
        int N = srcPts.size();
        if (N != dstPts.size()) {
            throw new IllegalArgumentException("From and to lists must be the same size");
        }
        if (N < 3) {
            throw new IllegalArgumentException("Must be at least 3 points");
        }
        if (this.A.data.length < N * 3) {
            this.A.reshape(N, 3, true);
            this.y.reshape(N, 2, true);
            for (i = 0; i < N; ++i) {
                this.A.set(i, 2, 1.0f);
            }
        } else {
            this.A.reshape(N, 3, false);
            this.y.reshape(N, 2, false);
        }
        for (i = 0; i < N; ++i) {
            Point2D_F32 pt2 = srcPts.get(i);
            Point2D_F32 pt1 = dstPts.get(i);
            this.A.set(i, 0, pt2.x);
            this.A.set(i, 1, pt2.y);
            this.y.set(i, 0, pt1.x);
            this.y.set(i, 1, pt1.y);
        }
        if (!this.solver.setA(this.A)) {
            return false;
        }
        this.solver.solve(this.y, this.x);
        this.model.a11 = this.x.data[0];
        this.model.a12 = this.x.data[2];
        this.model.tx = this.x.data[4];
        this.model.a21 = this.x.data[1];
        this.model.a22 = this.x.data[3];
        this.model.ty = this.x.data[5];
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

