/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.separator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class DarkSeparatorUI
extends BasicSeparatorUI {
    protected Color color;
    protected Dimension size;

    public static ComponentUI createUI(JComponent c) {
        return new DarkSeparatorUI();
    }

    @Override
    protected void installDefaults(JSeparator s) {
        super.installDefaults(s);
        s.setAlignmentX(0.0f);
        this.color = UIManager.getColor("Separator.foreground");
        this.size = UIManager.getDimension("Separator.size");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c instanceof JSeparator)) {
            return;
        }
        g.setColor(this.color);
        if (((JSeparator)c).getOrientation() == 1) {
            g.fillRect(this.size.width / 2, 0, 1, this.size.height);
        } else {
            g.fillRect(0, this.size.width / 2, this.size.height, 1);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(this.size.width, this.size.height);
        }
        return new Dimension(this.size.height, this.size.width);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }
}

