/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.util.Animator;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class DarkScrollBarUI
extends BasicScrollBarUI {
    protected static final String KEY_PREFIX = "JScrollBar.";
    public static final String KEY_SCROLL_PANE_PARENT = "JScrollBar.scrollPaneParent";
    public static final String KEY_FAST_WHEEL_SCROLLING = "JScrollBar.fastWheelScrolling";
    public static final String KEY_THIN = "JScrollBar.thin";
    private static final float THUMB_ALPHA = 0.6f;
    private static final float MAX_TRACK_ALPHA = 0.3f;
    private static final float MAX_THUMB_ALPHA = 1.0f;
    private static final int DELAY_FRAMES = 6;
    private static final int FADEOUT_FRAMES_COUNT = 16;
    private static final int FADEIN_FRAMES_COUNT = 8;
    private static final int FADEOUT_FRAME_COUNT_FACTOR = 50;
    private static final int FADEIN_FRAME_COUNT_FACTOR = 25;
    private static final int THICKNESS = 10;
    private static final int THICKNESS_THIN = 8;
    private static final AlphaComposite COMPOSITE = AlphaComposite.getInstance(3);
    private final MouseWheelListener mouseWheelListener = e -> {
        if (this.scrollbar.getParent() instanceof JScrollPane && !((JScrollPane)this.scrollbar.getParent()).isWheelScrollingEnabled()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1 && !e.isShiftDown() || this.scrollbar.getOrientation() == 0 && e.isShiftDown()) {
            this.scrollbar.setValueIsAdjusting(true);
            Object sp = this.scrollbar.getClientProperty(KEY_SCROLL_PANE_PARENT);
            if (this.scrollbar.getParent() instanceof JScrollPane) {
                DarkScrollBarUI.doScroll(this.scrollbar, ((JScrollPane)this.scrollbar.getParent()).getViewport(), e, this.scrollbar.getParent().getComponentOrientation().isLeftToRight());
            } else if (sp instanceof JScrollPane) {
                DarkScrollBarUI.doScroll(this.scrollbar, ((JScrollPane)sp).getViewport(), e, this.scrollbar.getParent().getComponentOrientation().isLeftToRight());
            } else {
                DarkScrollBarUI.doScroll(this.scrollbar, null, e, this.scrollbar.getComponentOrientation().isLeftToRight());
            }
            this.scrollbar.setValueIsAdjusting(false);
        }
    };
    protected Color thumbBorderColor;
    protected Color thumbFadeStartColor;
    protected Color thumbFadeEndColor;
    protected Color trackBackground;
    private float trackAlpha;
    private float thumbAlpha;
    private Animator trackFadeoutAnimator;
    private Animator trackFadeinAnimator;
    private Animator thumbFadeoutAnimator;
    private Animator thumbFadeinAnimator;
    private boolean mouseOverTrack = false;
    private boolean mouseOverThumb = false;
    private final MouseMotionListener mouseMotionListener = e -> {
        if (e == null) {
            return;
        }
        boolean overThumb = this.isOverThumb(e.getPoint());
        if (overThumb != this.mouseOverThumb) {
            this.mouseOverThumb = overThumb;
            if (!this.scrollbar.getValueIsAdjusting()) {
                this.resetThumbAnimator();
            }
        }
    };
    private final AdjustmentListener adjustmentListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!e.getValueIsAdjusting()) {
                return;
            }
            JScrollBar scrollBar = (JScrollBar)e.getAdjustable();
            int extent = scrollBar.getModel().getExtent();
            int value = scrollBar.getValue() + extent;
            if (value == extent || value == scrollBar.getMaximum()) {
                return;
            }
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, DarkScrollBarUI.this.scrollbar);
            if (!(DarkScrollBarUI.this.getThumbBounds().contains(p) || e.getValueIsAdjusting() || DarkScrollBarUI.this.thumbFadeinAnimator.isRunning())) {
                DarkScrollBarUI.this.mouseOverThumb = true;
                DarkScrollBarUI.this.resetThumbAnimator();
            }
        }
    };
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!DarkScrollBarUI.this.getTrackBounds().contains(e.getPoint())) {
                DarkScrollBarUI.this.mouseOverTrack = false;
                DarkScrollBarUI.this.resetTrackAnimator();
            }
            if (!DarkScrollBarUI.this.getThumbBounds().contains(e.getPoint())) {
                DarkScrollBarUI.this.mouseOverThumb = false;
                DarkScrollBarUI.this.resetThumbAnimator();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (DarkScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            DarkScrollBarUI.this.mouseOverTrack = true;
            if (!DarkScrollBarUI.this.scrollbar.getValueIsAdjusting()) {
                DarkScrollBarUI.this.resetTrackAnimator();
            }
            DarkScrollBarUI.this.mouseMotionListener.mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (DarkScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            DarkScrollBarUI.this.mouseOverTrack = false;
            if (!DarkScrollBarUI.this.scrollbar.getValueIsAdjusting()) {
                DarkScrollBarUI.this.resetTrackAnimator();
            }
            DarkScrollBarUI.this.mouseMotionListener.mouseMoved(e);
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkScrollBarUI();
    }

    public static void doScroll(JScrollBar toScroll, JViewport vp, MouseWheelEvent e, boolean leftToRight) {
        int direction = e.getWheelRotation() < 0 ? -1 : 1;
        int orientation = toScroll.getOrientation();
        if (!leftToRight && orientation == 0) {
            direction *= -1;
        }
        if (e.getScrollType() == 0) {
            Component comp;
            int units = Math.abs(e.getUnitsToScroll());
            boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
            Object fastWheelScroll = toScroll.getClientProperty(KEY_FAST_WHEEL_SCROLLING);
            Component component = comp = vp == null ? null : vp.getView();
            if (Boolean.TRUE.equals(fastWheelScroll) && comp instanceof Scrollable) {
                Scrollable scrollComp = (Scrollable)((Object)comp);
                Rectangle viewRect = vp.getViewRect();
                int startingX = viewRect.x;
                int scrollMin = toScroll.getMinimum();
                int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                if (limitScroll) {
                    int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                    if (direction < 0) {
                        scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                    } else {
                        scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                    }
                }
                for (int i = 0; i < units; ++i) {
                    int unitIncr = scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction);
                    if (orientation == 1) {
                        if (direction < 0) {
                            viewRect.y -= unitIncr;
                            if (viewRect.y > scrollMin) continue;
                            viewRect.y = scrollMin;
                            break;
                        }
                        viewRect.y += unitIncr;
                        if (viewRect.y < scrollMax) continue;
                        viewRect.y = scrollMax;
                        break;
                    }
                    if (leftToRight && direction < 0 || !leftToRight && direction > 0) {
                        viewRect.x -= unitIncr;
                        if (!leftToRight || viewRect.x >= scrollMin) continue;
                        viewRect.x = scrollMin;
                        break;
                    }
                    viewRect.x += unitIncr;
                    if (!leftToRight || viewRect.x <= scrollMax) continue;
                    viewRect.x = scrollMax;
                    break;
                }
                if (orientation == 1) {
                    toScroll.setValue(viewRect.y);
                } else if (leftToRight) {
                    toScroll.setValue(viewRect.x);
                } else {
                    int newPos = toScroll.getValue() - (viewRect.x - startingX);
                    if (newPos < scrollMin) {
                        newPos = scrollMin;
                    } else if (newPos > scrollMax) {
                        newPos = scrollMax;
                    }
                    toScroll.setValue(newPos);
                }
            } else {
                DarkScrollBarUI.scrollByUnits(toScroll, direction, units, limitScroll);
            }
        } else if (e.getScrollType() == 1) {
            DarkScrollBarUI.scrollByBlock(toScroll, direction);
        }
    }

    static void scrollByUnits(JScrollBar scrollbar, int direction, int units, boolean limitToBlock) {
        int limit = -1;
        if (limitToBlock) {
            limit = direction < 0 ? scrollbar.getValue() - scrollbar.getBlockIncrement(direction) : scrollbar.getValue() + scrollbar.getBlockIncrement(direction);
        }
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? scrollbar.getUnitIncrement(direction) : -scrollbar.getUnitIncrement(direction);
            int oldValue = scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            if (limitToBlock && i > 0) {
                assert (limit != -1);
                if (direction < 0 && newValue < limit || direction > 0 && newValue > limit) break;
            }
            scrollbar.setValue(newValue);
        }
    }

    static void scrollByBlock(JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollbar.setFocusable(false);
    }

    @Override
    protected void installDefaults() {
        int incGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.put("ScrollBar.incrementButtonGap", 0);
            UIManager.put("ScrollBar.decrementButtonGap", 0);
            super.installDefaults();
        }
        finally {
            UIManager.put("ScrollBar.incrementButtonGap", incGap);
            UIManager.put("ScrollBar.decrementButtonGap", decGap);
        }
        this.thumbBorderColor = UIManager.getColor("ScrollBar.thumbBorderColor");
        this.thumbFadeStartColor = UIManager.getColor("ScrollBar.fadeStartColor");
        this.thumbFadeEndColor = UIManager.getColor("ScrollBar.fadeEndColor");
        this.trackBackground = UIManager.getColor("ScrollBar.trackColor");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.trackFadeoutAnimator == null || this.trackFadeoutAnimator.isDisposed()) {
            this.trackFadeoutAnimator = this.createTrackFadeoutAnimator();
        }
        if (this.thumbFadeoutAnimator == null || this.thumbFadeoutAnimator.isDisposed()) {
            this.thumbFadeoutAnimator = this.createThumbFadeoutAnimator();
        }
        if (this.trackFadeinAnimator == null || this.trackFadeinAnimator.isDisposed()) {
            this.trackFadeinAnimator = this.createTrackFadeinAnimator();
        }
        if (this.thumbFadeinAnimator == null || this.thumbFadeinAnimator.isDisposed()) {
            this.thumbFadeinAnimator = this.createThumbFadeinAnimator();
        }
        this.scrollbar.addAdjustmentListener(this.adjustmentListener);
        this.scrollbar.addMouseMotionListener(this.mouseMotionListener);
        this.scrollbar.addMouseListener(this.mouseListener);
        this.scrollbar.addMouseWheelListener(this.mouseWheelListener);
    }

    @Override
    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeMouseListener(this.mouseListener);
        this.scrollbar.removeMouseWheelListener(this.mouseWheelListener);
        this.scrollbar.removeMouseMotionListener(this.mouseMotionListener);
        this.scrollbar.removeAdjustmentListener(this.adjustmentListener);
        this.trackFadeoutAnimator.dispose();
        this.thumbFadeoutAnimator.dispose();
        this.trackFadeinAnimator.dispose();
        this.thumbFadeinAnimator.dispose();
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DarkScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle bounds) {
        if (c.isOpaque()) {
            g.setColor(this.scrollbar.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (this.trackAlpha == 0.0f) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.getTrackColor());
        g2.setComposite(COMPOSITE.derive(this.trackAlpha));
        g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g2.dispose();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!thumbBounds.isEmpty() && this.scrollbar.isEnabled()) {
            this.paintMaxiThumb((Graphics2D)g, thumbBounds);
        }
    }

    protected void paintMaxiThumb(Graphics2D g, Rectangle rect) {
        Composite c = g.getComposite();
        g.setComposite(COMPOSITE.derive(0.6f));
        Color thumbColor = this.getThumbColor();
        double percent = Math.min(1.0, Math.max(0.0, (double)(1.0f - (this.thumbAlpha - 0.6f))));
        g.setColor(DarkUIUtil.blendColors(this.thumbBorderColor, thumbColor, percent));
        DarkUIUtil.drawRect(g, rect.x, rect.y, rect.width, rect.height, 1);
        g.setColor(thumbColor);
        g.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g.setComposite(c);
    }

    private Color getThumbColor() {
        return DarkUIUtil.blendColors(this.thumbFadeEndColor, this.thumbFadeStartColor, this.thumbAlpha);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return this.isVertical() ? new Dimension(this.getThickness(), this.getThickness() * 2) : new Dimension(this.getThickness() * 2, this.getThickness());
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected Color getTrackColor() {
        return this.trackBackground;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMinimumThumbSize();
    }

    protected boolean isVertical() {
        return this.scrollbar.getOrientation() == 1;
    }

    private int getThickness() {
        return this.isThin() ? 8 : 10;
    }

    protected boolean isThin() {
        return this.scrollbar.getClientProperty(KEY_THIN) == Boolean.TRUE;
    }

    private Animator createTrackFadeoutAnimator() {
        return new Animator("Track fadeout", 16, 800, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                DarkScrollBarUI.this.trackAlpha = 0.3f;
                if (frame > 6) {
                    DarkScrollBarUI.this.trackAlpha *= (float)(1.0 - (double)frame / (double)totalFrames);
                }
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
            }

            @Override
            protected void paintCycleEnd() {
                DarkScrollBarUI.this.trackAlpha = 0.0f;
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
            }
        };
    }

    private Animator createThumbFadeoutAnimator() {
        return new Animator("Adjustment fadeout", 16, 800, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                DarkScrollBarUI.this.thumbAlpha = 1.0f;
                if (frame > 6) {
                    DarkScrollBarUI.this.thumbAlpha *= (float)(1.0 - (double)frame / (double)totalFrames);
                }
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
            }

            @Override
            protected void paintCycleEnd() {
                DarkScrollBarUI.this.thumbAlpha = 0.0f;
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
            }
        };
    }

    private Animator createTrackFadeinAnimator() {
        return new Animator("Track fadein", 8, 200, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                DarkScrollBarUI.this.trackAlpha = (float)frame * 0.3f / (float)totalFrames;
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
            }

            @Override
            protected void paintCycleEnd() {
                DarkScrollBarUI.this.trackAlpha = 0.3f;
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
            }
        };
    }

    private Animator createThumbFadeinAnimator() {
        return new Animator("Adjustment fadein", 4, 200, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                DarkScrollBarUI.this.thumbAlpha = (float)frame * 1.0f / (float)totalFrames;
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
            }

            @Override
            protected void paintCycleEnd() {
                DarkScrollBarUI.this.thumbAlpha = 1.0f;
                if (DarkScrollBarUI.this.scrollbar != null) {
                    ((JComponent)DarkScrollBarUI.this.scrollbar.getParent()).paintImmediately(DarkScrollBarUI.this.scrollbar.getBounds());
                }
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, DarkScrollBarUI.this.scrollbar);
                if (!DarkScrollBarUI.this.getThumbBounds().contains(p) && !DarkScrollBarUI.this.scrollbar.getValueIsAdjusting()) {
                    DarkScrollBarUI.this.mouseOverThumb = false;
                    DarkScrollBarUI.this.resetThumbAnimator();
                }
            }
        };
    }

    private void resetThumbAnimator() {
        this.resetAnimators(this.thumbFadeinAnimator, this.thumbFadeoutAnimator, this.mouseOverThumb, this.thumbAlpha, 1.0f);
    }

    private void resetTrackAnimator() {
        this.resetAnimators(this.trackFadeinAnimator, this.trackFadeoutAnimator, this.mouseOverTrack, this.trackAlpha, 0.3f);
    }

    private void resetAnimators(Animator fadeInAnimator, Animator fadeOutAnimator, boolean overAnimatedComponent, float currentAlpha, float maxAlpha) {
        fadeInAnimator.reset();
        fadeOutAnimator.reset();
        if (this.scrollbar != null && (this.scrollbar.getValueIsAdjusting() || overAnimatedComponent)) {
            fadeOutAnimator.suspend();
            int startFrame = (int)(currentAlpha / maxAlpha * fadeInAnimator.getTotalFrames());
            fadeInAnimator.resume(startFrame);
        } else {
            fadeInAnimator.suspend();
            int startFrame = 0;
            if (currentAlpha < maxAlpha) {
                startFrame = (int)((1.0 - (double)(currentAlpha / maxAlpha)) * (double)fadeOutAnimator.getTotalFrames());
            }
            fadeOutAnimator.resume(startFrame);
        }
    }

    private boolean isOverThumb(Point p) {
        Rectangle bounds = this.getThumbBounds();
        return bounds != null && bounds.contains(p);
    }

    private static final class EmptyButton
    extends JButton
    implements UIResource {
        private EmptyButton() {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }
}

