/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.color.DarkColorModel;
import com.github.weisj.darklaf.components.DefaultColorPipette;
import com.github.weisj.darklaf.components.uiresource.JButtonUIResource;
import com.github.weisj.darklaf.decorators.AncestorAdapter;
import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.ui.colorchooser.ColorPipette;
import com.github.weisj.darklaf.ui.colorchooser.ColorPreviewComponent;
import com.github.weisj.darklaf.ui.colorchooser.ColorValueFormatter;
import com.github.weisj.darklaf.ui.colorchooser.ColorWheelPanel;
import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DarkColorChooserPanel
extends AbstractColorChooserPanel
implements ColorListener {
    public static final String TRANSPARENCY_ENABLED_PROPERTY = "TransparencyEnabled";
    private final ColorPipette pipette;
    private final ColorWheelPanel colorWheelPanel;
    private final JFormattedTextField textHex;
    private final ColorValueFormatter hexFormatter;
    private final JFormattedTextField[] valueFields;
    private final ColorValueFormatter[] formatters;
    private final JComboBox<DarkColorModel> formatBox;
    private final ColorPreviewComponent previewComponent;
    private final JLabel[] descriptors;
    private final JLabel[] descriptorsAfter;
    private final boolean doneInit;
    private Color currentColor;
    private boolean isChanging;
    private Icon pipetteIcon;
    private Icon pipetteHoverIcon;

    public DarkColorChooserPanel(DarkColorModel ... colorModels) {
        if (colorModels == null || colorModels.length == 0) {
            throw new IllegalArgumentException("Must pass at least one valid colorModel");
        }
        this.previewComponent = new ColorPreviewComponent();
        this.colorWheelPanel = new ColorWheelPanel(this, true, true);
        this.pipette = new DefaultColorPipette(this, this.colorWheelPanel::setColor);
        this.pipetteIcon = UIManager.getIcon("ColorChooser.pipette.icon");
        this.pipetteHoverIcon = UIManager.getIcon("ColorChooser.pipetteRollover.icon");
        this.formatBox = new JComboBox<DarkColorModel>(colorModels);
        this.formatBox.addActionListener(e -> {
            this.updateDescriptors();
            this.updateValueFields();
            this.updateFormatters();
            this.applyColorToFields(this.getColorFromModel());
            this.doLayout();
        });
        int record = 0;
        DarkColorModel prototype = null;
        for (DarkColorModel model : colorModels) {
            record = Math.max(model.getValueCount(), record);
            String name = model.toString();
            if (prototype != null && prototype.toString().length() >= name.length()) continue;
            prototype = model;
        }
        this.formatBox.setPrototypeDisplayValue(prototype);
        this.descriptors = new JLabel[record];
        this.descriptorsAfter = new JLabel[record];
        this.textHex = this.createColorField(true);
        this.textHex.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DarkColorChooserPanel.this.textHex.requestFocus();
                DarkColorChooserPanel.this.textHex.removeAncestorListener(this);
            }
        });
        this.hexFormatter = ColorValueFormatter.init(this.getDarkColorModel(), 0, true, this.textHex);
        this.hexFormatter.setTransparencyEnabled(this.isColorTransparencySelectionEnabled());
        this.valueFields = new JFormattedTextField[record];
        this.formatters = new ColorValueFormatter[record];
        for (int i = 0; i < record; ++i) {
            this.descriptors[i] = new JLabel();
            this.descriptorsAfter[i] = new JLabel();
            this.valueFields[i] = this.createColorField(false);
            this.formatters[i] = ColorValueFormatter.init(this.getDarkColorModel(), i, false, this.valueFields[i]);
        }
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)this.buildTopPanel(UIManager.getBoolean("ColorChooser.pipetteEnabled")), "North");
        this.add((Component)this.colorWheelPanel, "Center");
        this.add(Box.createVerticalStrut(10), "South");
        this.updateValueFields();
        this.updateDescriptors();
        this.doneInit = true;
    }

    private void updateDescriptors() {
        char[] desc = this.getDarkColorModel().getLabelDescriptorsBefore();
        char[] descAfter = this.getDarkColorModel().getLabelDescriptorsAfter();
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (i < desc.length) {
                this.descriptors[i].setText(desc[i] + ":");
            } else {
                this.descriptors[i].setText("");
            }
            if (i < descAfter.length) {
                this.descriptorsAfter[i].setText(String.valueOf(descAfter[i]));
                continue;
            }
            this.descriptorsAfter[i].setText("");
        }
    }

    private void updateValueFields() {
        DarkColorModel model = this.getDarkColorModel();
        int count = model.getValueCount();
        for (int i = 0; i < this.valueFields.length; ++i) {
            this.valueFields[i].setEnabled(i < count);
            this.valueFields[i].setVisible(i < count);
        }
    }

    private void updateFormatters() {
        for (ColorValueFormatter formatter : this.formatters) {
            formatter.setModel(this.getDarkColorModel());
        }
    }

    private void applyColorToFields(Color color) {
        DarkColorModel model = this.getDarkColorModel();
        this.isChanging = true;
        int[] values = model.getValuesFromColor(color);
        for (int i = 0; i < values.length; ++i) {
            this.valueFields[i].setValue(values[i]);
        }
        this.isChanging = false;
    }

    @Override
    protected Color getColorFromModel() {
        Color c = super.getColorFromModel();
        return c == null ? this.currentColor : c;
    }

    protected DarkColorModel getDarkColorModel() {
        return (DarkColorModel)this.formatBox.getSelectedItem();
    }

    private JComponent buildTopPanel(boolean enablePipette) {
        JPanel result = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        if (enablePipette && this.pipette != null) {
            JButtonUIResource pipetteButton = new JButtonUIResource();
            pipetteButton.putClientProperty("JButton.variant", "onlyLabel");
            pipetteButton.putClientProperty("JButton.thin", Boolean.TRUE);
            pipetteButton.setRolloverEnabled(true);
            pipetteButton.setIcon(this.getPipetteIcon());
            pipetteButton.setRolloverIcon(this.getPipetteRolloverIcon());
            pipetteButton.setDisabledIcon(this.getPipetteRolloverIcon());
            pipetteButton.setPressedIcon(this.getPipetteRolloverIcon());
            pipetteButton.setFocusable(false);
            pipetteButton.addActionListener(e -> {
                pipetteButton.setEnabled(false);
                this.pipette.setInitialColor(this.getColorFromModel());
                this.pipette.show();
            });
            ((DefaultColorPipette)this.pipette).setCloseAction(() -> pipetteButton.setEnabled(true));
            previewPanel.add((Component)pipetteButton, "West");
        }
        previewPanel.add((Component)this.previewComponent, "Center");
        result.add((Component)previewPanel, "North");
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BoxLayout(valuePanel, 0));
        valuePanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        for (int i = 0; i < this.descriptorsAfter.length; ++i) {
            this.descriptorsAfter[i].setPreferredSize(new Dimension(14, -1));
            this.descriptors[i].setPreferredSize(new Dimension(14, -1));
            valuePanel.add(this.descriptors[i]);
            valuePanel.add(this.valueFields[i]);
            valuePanel.add(this.descriptorsAfter[i]);
            if (i >= this.descriptorsAfter.length - 1) continue;
            valuePanel.add(Box.createHorizontalStrut(2));
        }
        result.add((Component)valuePanel, "West");
        JPanel hexPanel = new JPanel();
        hexPanel.setLayout(new BoxLayout(hexPanel, 0));
        hexPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        hexPanel.add(this.formatBox);
        hexPanel.add(Box.createHorizontalStrut(2));
        hexPanel.add(new JLabel("#"));
        hexPanel.add(this.textHex);
        result.add((Component)hexPanel, "East");
        return result;
    }

    private JFormattedTextField createColorField(boolean hex) {
        final JFormattedTextField field = new JFormattedTextField((Object)0);
        field.setColumns(hex ? 8 : 4);
        if (!hex) {
            field.addPropertyChangeListener(e -> {
                if ("value".equals(e.getPropertyName())) {
                    this.updatePreviewFromTextFields();
                }
            });
        } else {
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                protected void update() {
                    try {
                        if (DarkColorChooserPanel.this.isChanging) {
                            return;
                        }
                        String hexStr = String.format("%1$-8s", field.getText()).replaceAll(" ", "F");
                        int alpha = DarkColorChooserPanel.this.isColorTransparencySelectionEnabled() ? Integer.valueOf(hexStr.substring(6, 8), 16) : 255;
                        Color c = new Color(Integer.valueOf(hexStr.substring(0, 2), 16), Integer.valueOf(hexStr.substring(2, 4), 16), Integer.valueOf(hexStr.substring(4, 6), 16), alpha);
                        DarkColorChooserPanel.this.colorWheelPanel.setColor(c, DarkColorChooserPanel.this.textHex);
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        field.setFocusLostBehavior(1);
        return field;
    }

    protected Icon getPipetteIcon() {
        return this.pipetteIcon;
    }

    protected Icon getPipetteRolloverIcon() {
        return this.pipetteHoverIcon;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(520, 420);
    }

    @Override
    public void updateChooser() {
        if (this.isChanging) {
            return;
        }
        Color color = this.getColorFromModel();
        if (color != null) {
            this.colorWheelPanel.setColor(color, this);
        }
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return "Color Wheel";
    }

    @Override
    public int getMnemonic() {
        return 87;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return 6;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public boolean isColorTransparencySelectionEnabled() {
        return this.colorWheelPanel.isColorTransparencySelectionEnabled();
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    private void updatePreviewFromTextFields() {
        if (!this.doneInit || this.isChanging) {
            return;
        }
        this.isChanging = true;
        int[] values = new int[this.valueFields.length];
        for (int i = 0; i < this.valueFields.length; ++i) {
            values[i] = (Integer)this.valueFields[i].getValue();
        }
        Color color = this.getDarkColorModel().getColorFromValues(values);
        if (this.isColorTransparencySelectionEnabled()) {
            color = ColorUtil.toAlpha(color, this.getColorFromModel().getAlpha());
        }
        this.colorWheelPanel.setColor(color, this.valueFields[0]);
        this.isChanging = false;
    }

    @Override
    public void setColorTransparencySelectionEnabled(boolean b) {
        boolean oldValue = this.isColorTransparencySelectionEnabled();
        if (b != oldValue) {
            Color color = this.getColorFromModel();
            color = new Color(color.getRed(), color.getBlue(), color.getGreen());
            ColorSelectionModel model = this.getColorSelectionModel();
            if (model != null) {
                model.setSelectedColor(color);
            }
            this.currentColor = color;
            this.hexFormatter.setTransparencyEnabled(b);
            this.colorWheelPanel.setColorTransparencySelectionEnabled(b);
            this.applyColorToHEX(this.getColorFromModel());
            this.firePropertyChange(TRANSPARENCY_ENABLED_PROPERTY, oldValue, b);
        }
    }

    @Override
    public void colorChanged(Color color, Object source) {
        this.isChanging = true;
        if (color != null && !color.equals(this.currentColor)) {
            Color newColor = !this.isColorTransparencySelectionEnabled() ? new Color(color.getRed(), color.getGreen(), color.getBlue()) : color;
            ColorSelectionModel model = this.getColorSelectionModel();
            if (model != null) {
                model.setSelectedColor(newColor);
            }
            this.currentColor = newColor;
            this.previewComponent.setColor(newColor);
            if (!(source instanceof JFormattedTextField)) {
                this.applyColorToFields(newColor);
            }
            if (source != this.textHex) {
                this.applyColorToHEX(newColor);
            }
        }
        this.isChanging = false;
    }

    private void applyColorToHEX(Color c) {
        boolean changingOld = this.isChanging;
        this.isChanging = true;
        boolean transparencyEnabled = this.isColorTransparencySelectionEnabled();
        if (transparencyEnabled) {
            this.textHex.setValue(c);
        } else {
            this.textHex.setValue(ColorUtil.removeAlpha(c));
        }
        this.isChanging = changingOld;
    }
}

