/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class ColorWheelImageProducer
extends MemoryImageSource {
    private final int[] myPixels;
    private final int myWidth;
    private final int myHeight;
    private float myBrightness;
    private float[] myHues;
    private float[] mySat;
    private int[] myAlphas;

    public ColorWheelImageProducer(int w, int h, float brightness) {
        super(w, h, null, 0, w);
        this.myPixels = new int[w * h];
        this.myWidth = w;
        this.myHeight = h;
        this.myBrightness = brightness;
        this.generateLookupTables();
        this.newPixels(this.myPixels, ColorModel.getRGBdefault(), 0, w);
        this.setAnimated(true);
        this.generateColorWheel();
    }

    private void generateLookupTables() {
        this.mySat = new float[this.myWidth * this.myHeight];
        this.myHues = new float[this.myWidth * this.myHeight];
        this.myAlphas = new int[this.myWidth * this.myHeight];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.myWidth / 2;
        int cy = this.myHeight / 2;
        for (int x = 0; x < this.myWidth; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.myHeight; ++y) {
                int ky = cy - y;
                int index = x + y * this.myWidth;
                this.mySat[index] = (float)Math.sqrt(squarekx + ky * ky) / radius;
                if (this.mySat[index] <= 1.0f) {
                    this.myAlphas[index] = -16777216;
                } else {
                    this.myAlphas[index] = (int)((blend - Math.min(blend, this.mySat[index] - 1.0f)) * 255.0f / blend) << 24;
                    this.mySat[index] = 1.0f;
                }
                if (this.myAlphas[index] == 0) continue;
                this.myHues[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0);
            }
        }
    }

    public void generateColorWheel() {
        for (int index = 0; index < this.myPixels.length; ++index) {
            if (this.myAlphas[index] == 0) continue;
            this.myPixels[index] = this.myAlphas[index] | 0xFFFFFF & Color.HSBtoRGB(this.myHues[index], this.mySat[index], this.myBrightness);
        }
        this.newPixels();
    }

    public int getRadius() {
        return Math.min(this.myWidth, this.myHeight) / 2 - 2;
    }
}

