/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;

final class ColorPreviewComponent
extends JComponent {
    protected Color borderColor;
    private Color myColor;

    ColorPreviewComponent() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.borderColor = UIManager.getColor("ColorChooser.previewBorderColor");
    }

    public void setColor(Color c) {
        this.myColor = c;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets i = this.getInsets();
        Rectangle r = this.getBounds();
        int width = r.width - i.left - i.right;
        int height = r.height - i.top - i.bottom;
        g.setColor(Color.WHITE);
        g.fillRect(i.left, i.top, width, height);
        g.setColor(this.myColor);
        g.fillRect(i.left + 1, i.top + 1, width - 2, height - 2);
        g.setColor(this.borderColor);
        g.fillRect(i.left, i.top, width, 1);
        g.fillRect(i.left, i.top, 1, height);
        g.fillRect(i.left + width - 1, i.top, 1, height);
        g.fillRect(i.left, i.top + height - 1, width, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 32);
    }
}

