/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui;

import com.github.weisj.darklaf.platform.Decorations;
import com.github.weisj.darklaf.ui.tooltip.DarkTooltipBorder;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class DarkPopupFactory
extends PopupFactory {
    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        Window window;
        Popup popup = super.getPopup(owner, contents, x, y);
        boolean isMediumWeight = popup.getClass().getSimpleName().endsWith("MediumWeightPopup");
        boolean isLightWeight = popup.getClass().getSimpleName().endsWith("LightWeightPopup");
        boolean isBalloonTooltip = contents instanceof JToolTip && ((JToolTip)contents).getBorder() instanceof DarkTooltipBorder;
        boolean isPopupMenu = contents instanceof JPopupMenu;
        if (isMediumWeight || isLightWeight) {
            JRootPane rootPane;
            if (isBalloonTooltip) {
                popup = super.getPopup(null, contents, x, y);
            } else if (isMediumWeight && (rootPane = SwingUtilities.getRootPane(contents)) != null) {
                rootPane.putClientProperty("mediumWeightPopupRoot", true);
            }
        }
        if ((window = SwingUtilities.getWindowAncestor(contents)) != null) {
            boolean install = true;
            if (window instanceof RootPaneContainer) {
                JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                rootPane.putClientProperty("JRootPane.isPopup", true);
                boolean bl = install = !Boolean.TRUE.equals(rootPane.getClientProperty("JRootPane.isToolTip"));
            }
            if (install) {
                Decorations.installPopupWindow(window);
            } else {
                Decorations.uninstallPopupWindow(window);
            }
            if (isBalloonTooltip || isPopupMenu) {
                if (isPopupMenu) {
                    ((JComponent)contents).putClientProperty("PopupFactory.makeVisible", true);
                }
                window.setOpacity(0.0f);
            }
        }
        return popup;
    }
}

