/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows.ui;

import com.github.weisj.darklaf.decorations.CustomTitlePane;
import com.github.weisj.darklaf.icons.ScaledIcon;
import com.github.weisj.darklaf.icons.ToggleIcon;
import com.github.weisj.darklaf.platform.PointerUtil;
import com.github.weisj.darklaf.platform.windows.JNIDecorationsWindows;
import com.github.weisj.darklaf.util.Scale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import sun.awt.SunToolkit;

public class WindowsTitlePane
extends CustomTitlePane {
    public static final String KEY_RESIZABLE = "resizable";
    public static final String KEY_STATE = "state";
    public static final String KEY_ICON_IMAGE = "iconImage";
    private static final int PAD = 5;
    private static final int BAR_HEIGHT = 28;
    private static final int BUTTON_WIDTH = 46;
    private static final int ICON_WIDTH = 32;
    private static final int ICON_SIZE = 17;
    private final JRootPane rootPane;
    private final ContainerListener layeredPaneContainerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JMenuBar) {
                WindowsTitlePane.this.menuBar = WindowsTitlePane.this.getRootPane().getJMenuBar();
                WindowsTitlePane.this.menuBar.setPreferredSize(new Dimension(0, 0));
                WindowsTitlePane.this.add(WindowsTitlePane.this.menuBar);
            }
            if (WindowsTitlePane.this.getRootPane().getJMenuBar() == null && WindowsTitlePane.this.menuBar != null) {
                WindowsTitlePane.this.remove(WindowsTitlePane.this.menuBar);
                WindowsTitlePane.this.menuBar = null;
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
        }
    };
    private boolean oldResizable;
    private PropertyChangeListener propertyChangeListener;
    private WindowListener windowListener;
    private ToggleIcon closeIcon;
    private ToggleIcon maximizeIcon;
    private ToggleIcon restoreIcon;
    private ToggleIcon minimizeIcon;
    private JButton windowIconButton;
    private JButton closeButton;
    private JButton maximizeToggleButton;
    private JButton minimizeButton;
    private Action closeAction;
    private Action restoreAction;
    private Action maximizeAction;
    private Action minimizeAction;
    private JLabel titleLabel;
    private Window window;
    private long windowHandle;
    private JMenuBar menuBar;
    private final ContainerListener rootPaneContainerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JLayeredPane) {
                ((JLayeredPane)e.getChild()).addContainerListener(WindowsTitlePane.this.layeredPaneContainerListener);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof JLayeredPane) {
                ((JLayeredPane)e.getChild()).removeContainerListener(WindowsTitlePane.this.layeredPaneContainerListener);
            }
        }
    };
    private int state;
    private Color inactiveBackground;
    private Color inactiveForeground;
    private Color activeBackground;
    private Color activeForeground;
    private Color border;

    public WindowsTitlePane(JRootPane root, int decorationStyle, Window window) {
        this.rootPane = root;
        this.window = window;
        this.rootPane.addContainerListener(this.rootPaneContainerListener);
        this.rootPane.getLayeredPane().addContainerListener(this.layeredPaneContainerListener);
        this.state = -1;
        this.oldResizable = true;
        this.installSubcomponents(decorationStyle);
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private static JButton createButton(String accessibleName, Icon icon, Action action) {
        return WindowsTitlePane.createButton(accessibleName, icon, action, false);
    }

    private static JButton createButton(String accessibleName, Icon icon, Action action, boolean close) {
        JButton button = new JButton(){

            @Override
            public boolean isRolloverEnabled() {
                return true;
            }
        };
        if (close) {
            button.putClientProperty("JButton.shadow.hover", UIManager.getColor("Windows.TitlePane.close.rollOverColor"));
            button.putClientProperty("JButton.shadow.click", UIManager.getColor("Windows.TitlePane.close.clickColor"));
        }
        button.putClientProperty("JButton.noShadowOverwrite", true);
        button.setFocusable(false);
        button.setOpaque(true);
        button.setRolloverEnabled(true);
        button.putClientProperty("JButton.variant", "fullShadow");
        button.putClientProperty("paintActive", Boolean.TRUE);
        button.putClientProperty("AccessibleName", accessibleName);
        button.setAction(action);
        button.setIcon(icon);
        button.setText(null);
        return button;
    }

    @Override
    public void uninstall() {
        this.uninstallListeners();
        this.uninstallDecorations();
        this.removeAll();
        if (this.menuBar != null) {
            this.getRootPane().setJMenuBar(this.menuBar);
        }
    }

    @Override
    public Insets getWindowSizeAdjustment() {
        Insets insets = this.window != null && this.windowHandle != 0L ? this.window.getInsets() : new Insets(0, 0, 0, 0);
        insets.set(-insets.top, -insets.left, -insets.bottom, -insets.right);
        return insets;
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.rootPane != null) {
            this.rootPane.removeContainerListener(this.rootPaneContainerListener);
            this.rootPane.getLayeredPane().removeContainerListener(this.layeredPaneContainerListener);
        }
    }

    protected void uninstallDecorations() {
        if (this.windowHandle != 0L) {
            JNIDecorationsWindows.uninstallDecorations(this.windowHandle);
            this.windowHandle = 0L;
        }
        this.rootPane.removeContainerListener(this.rootPaneContainerListener);
        this.rootPane.getLayeredPane().removeContainerListener(this.layeredPaneContainerListener);
        if (this.menuBar != null) {
            this.menuBar.setPreferredSize(null);
            this.rootPane.setJMenuBar(this.menuBar);
        }
    }

    @Override
    public void install() {
        if (this.window != null) {
            if (!this.installDecorations()) {
                return;
            }
            if (this.window instanceof Frame) {
                this.titleLabel.setText(((Frame)this.window).getTitle());
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            if (this.window instanceof Dialog) {
                this.titleLabel.setText(((Dialog)this.window).getTitle());
            }
            this.determineColors();
            this.setActive(this.window.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    private boolean installDecorations() {
        if (this.window instanceof Dialog || this.window instanceof Frame) {
            this.windowHandle = PointerUtil.getHWND(this.window);
            if (this.windowHandle != 0L) {
                JNIDecorationsWindows.installDecorations(this.windowHandle);
                this.updateResizeBehaviour();
                Color color = this.window.getBackground();
                JNIDecorationsWindows.setBackground(this.windowHandle, color.getRed(), color.getGreen(), color.getBlue());
                this.forceNativeResize();
            } else {
                this.uninstall();
                return false;
            }
        }
        return true;
    }

    private void forceNativeResize() {
        Rectangle bounds = this.window.getBounds();
        Dimension size = bounds.getSize();
        Point p = bounds.getLocation();
        if (this.window.isPreferredSizeSet()) {
            size = this.window.getPreferredSize();
        } else {
            p.x += size.width / 2;
            p.y += size.height / 2;
        }
        this.window.setSize(size.width, size.height + 1);
        this.window.setSize(size.width, size.height);
        this.window.setLocation(p.x - size.width / 2, p.y - size.height / 2);
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private void installSubcomponents(int decorationStyle) {
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(2);
        this.add(this.titleLabel);
        this.createIcons();
        this.createActions();
        this.createButtons();
        if (decorationStyle == 1) {
            this.windowIconButton = this.createWindowIcon();
            this.add(this.windowIconButton);
            this.add(this.minimizeButton);
            this.add(this.maximizeToggleButton);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.add(this.closeButton);
        }
        this.menuBar = this.getRootPane().getJMenuBar();
        if (this.menuBar != null) {
            this.menuBar.setPreferredSize(new Dimension(0, 0));
            this.add(this.menuBar);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 4: {
                this.activeBackground = UIManager.getColor("Windows.OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("Windows.OptionPane.errorDialog.titlePane.foreground");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("Windows.OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("Windows.OptionPane.questionDialog.titlePane.foreground");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("Windows.OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("Windows.OptionPane.warningDialog.titlePane.foreground");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("Windows.TitlePane.background");
                this.activeForeground = UIManager.getColor("Windows.TitlePane.foreground");
            }
        }
        this.inactiveBackground = UIManager.getColor("Windows.TitlePane.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("Windows.TitlePane.inactiveForeground");
        this.border = UIManager.getColor("Windows.TitlePane.borderColor");
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JButton createWindowIcon() {
        this.windowIconButton = new JButton();
        this.windowIconButton.putClientProperty("JButton.noShadowOverwrite", true);
        this.windowIconButton.setComponentPopupMenu(this.createMenu());
        this.windowIconButton.putClientProperty("JButton.variant", "onlyLabel");
        this.windowIconButton.addActionListener(e -> this.windowIconButton.getComponentPopupMenu().show(this.windowIconButton, this.windowIconButton.getWidth() / 2, this.windowIconButton.getHeight() / 2));
        this.windowIconButton.setFocusable(false);
        this.windowIconButton.setBorderPainted(false);
        return this.windowIconButton;
    }

    private JPopupMenu createMenu() {
        JPopupMenu menu = new JPopupMenu();
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JPopupMenu menu) {
        menu.add(new JMenuItem(this.restoreAction){
            {
                this.setDisabledIcon(WindowsTitlePane.this.restoreIcon);
            }
        });
        menu.add(new JMenuItem(this.minimizeAction){
            {
                this.setDisabledIcon(WindowsTitlePane.this.minimizeIcon);
            }
        });
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(new JMenuItem(this.maximizeAction){
                {
                    this.setDisabledIcon(WindowsTitlePane.this.maximizeIcon);
                }
            });
        }
        menu.add(new JSeparator());
        menu.add(new JMenuItem(this.closeAction){
            {
                this.setDisabledIcon(WindowsTitlePane.this.closeIcon);
            }
        });
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private Window getWindow() {
        return this.window;
    }

    private void minimize() {
        JNIDecorationsWindows.minimize(this.windowHandle);
    }

    private void maximize() {
        JNIDecorationsWindows.maximize(this.windowHandle);
    }

    private void restore() {
        JNIDecorationsWindows.restore(this.windowHandle);
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeAction = new MinimizeAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private void createIcons() {
        this.minimizeIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.minimize.icon"), UIManager.getIcon("Windows.TitlePane.minimizeInactive.icon"));
        this.maximizeIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.maximize.icon"), UIManager.getIcon("Windows.TitlePane.maximizeInactive.icon"));
        this.restoreIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.restore.icon"), UIManager.getIcon("Windows.TitlePane.restoreInactive.icon"));
        this.closeIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.close.icon"), UIManager.getIcon("Windows.TitlePane.close.icon"));
    }

    private void createButtons() {
        this.closeButton = WindowsTitlePane.createButton("Close", this.closeIcon, this.closeAction, true);
        this.closeButton.setRolloverIcon(UIManager.getIcon("Windows.TitlePane.closeHover.icon"));
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeButton = WindowsTitlePane.createButton("Iconify", this.minimizeIcon, this.minimizeAction);
            this.maximizeToggleButton = WindowsTitlePane.createButton("Maximize", this.maximizeIcon, this.restoreAction);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean active) {
        this.closeIcon.setActive(active);
        this.titleLabel.setForeground(active ? this.activeForeground : this.inactiveForeground);
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeIcon.setActive(active);
            this.maximizeIcon.setActive(active);
            this.restoreIcon.setActive(active);
        }
        this.getRootPane().repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        this.updateResizeBehaviour();
        Window window = this.getWindow();
        boolean active = window == null || window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        Color background = active ? this.activeBackground : this.inactiveBackground;
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        if (this.getWindowDecorationStyle() != 0 && this.menuBar != null) {
            g.setColor(this.border);
            g.fillRect(0, height - 1, width, 1);
        }
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private Frame getFrame() {
        if (this.window instanceof Frame) {
            return (Frame)this.window;
        }
        return null;
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    protected void updateResizeBehaviour() {
        boolean res = this.isResizable(this.window, this.rootPane);
        if (this.oldResizable != res) {
            this.oldResizable = res;
            JNIDecorationsWindows.setResizable(this.windowHandle, res);
        }
    }

    private void setState(int state, boolean updateRegardless) {
        Window wnd = this.getWindow();
        if (wnd != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.restoreIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.maximizeToggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.maximizeToggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.maximizeToggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.maximizeToggleButton.getParent() != null) {
                        this.remove(this.maximizeToggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.minimizeAction.setEnabled(false);
                this.remove(this.maximizeToggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    protected boolean isResizable(Window window, JRootPane rootPane) {
        if (0 == rootPane.getWindowDecorationStyle()) {
            return false;
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).isResizable();
        }
        if (window instanceof Frame) {
            return ((Frame)window).isResizable();
        }
        return false;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.maximizeToggleButton.setAction(action);
        this.maximizeToggleButton.setIcon(icon);
        this.maximizeToggleButton.setText(null);
    }

    protected boolean isLeftToRight(Window window) {
        return window == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
    }

    private void updateSystemIcon() {
        Window window = this.getWindow();
        if (window == null) {
            this.windowIconButton.setIcon(null);
            return;
        }
        List<Image> icons = window.getIconImages();
        assert (icons != null);
        Icon systemIcon = icons.size() == 0 ? UIManager.getIcon("Windows.TitlePane.icon") : (icons.size() == 1 ? new ScaledIcon(icons.get(0).getScaledInstance(Scale.scaleWidth(17), Scale.scaleHeight(17), 16)) : new ScaledIcon(SunToolkit.getScaledIconImage(icons, Scale.scaleWidth(17), Scale.scaleHeight(17))));
        if (this.windowIconButton != null) {
            this.windowIconButton.setIcon(systemIcon);
            SwingUtilities.invokeLater(this::repaint);
        }
    }

    private boolean hideTitleBar() {
        String title = this.titleLabel.getText();
        if (title == null) {
            title = "";
        }
        return this.windowHandle == 0L || this.getWindowDecorationStyle() == 0 && this.menuBar == null && title.length() == 0;
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            WindowsTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            WindowsTitlePane.this.setActive(false);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if (WindowsTitlePane.KEY_RESIZABLE.equals(name) || WindowsTitlePane.KEY_STATE.equals(name)) {
                Frame frame = WindowsTitlePane.this.getFrame();
                if (frame != null) {
                    WindowsTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if (WindowsTitlePane.KEY_RESIZABLE.equals(name)) {
                    JNIDecorationsWindows.setResizable(WindowsTitlePane.this.windowHandle, Boolean.TRUE.equals(pce.getNewValue()));
                    WindowsTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                WindowsTitlePane.this.titleLabel.setText(pce.getNewValue() == null ? "" : pce.getNewValue().toString());
                WindowsTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                WindowsTitlePane.this.revalidate();
                WindowsTitlePane.this.repaint();
            } else if (WindowsTitlePane.KEY_ICON_IMAGE.equals(name)) {
                WindowsTitlePane.this.updateSystemIcon();
                WindowsTitlePane.this.revalidate();
                WindowsTitlePane.this.repaint();
            } else if ("background".equals(name) && pce.getNewValue() instanceof Color) {
                Color color = (Color)pce.getNewValue();
                if (color == null) {
                    return;
                }
                JNIDecorationsWindows.setBackground(WindowsTitlePane.this.windowHandle, color.getRed(), color.getGreen(), color.getBlue());
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close", WindowsTitlePane.this.closeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.close();
        }
    }

    private class MinimizeAction
    extends AbstractAction {
        public MinimizeAction() {
            super("Minimize", WindowsTitlePane.this.minimizeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.minimize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super("Restore", WindowsTitlePane.this.restoreIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.restore();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super("Maximize", WindowsTitlePane.this.maximizeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.maximize();
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            if (WindowsTitlePane.this.hideTitleBar()) {
                return new Dimension(0, 0);
            }
            int size = this.computeHeight();
            return new Dimension(size + 1, size + 1);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            if (WindowsTitlePane.this.hideTitleBar()) {
                return 0;
            }
            FontMetrics fm = WindowsTitlePane.this.rootPane.getFontMetrics(WindowsTitlePane.this.getFont());
            int height = fm.getHeight() + 7;
            if (WindowsTitlePane.this.menuBar != null) {
                height = Math.max(height, ((WindowsTitlePane)WindowsTitlePane.this).menuBar.getMinimumSize().height);
            }
            return Math.max(28, height);
        }

        @Override
        public void layoutContainer(Container c) {
            if (WindowsTitlePane.this.hideTitleBar()) {
                if (WindowsTitlePane.this.windowIconButton != null) {
                    WindowsTitlePane.this.windowIconButton.setBounds(0, 0, 0, 0);
                }
                if (WindowsTitlePane.this.closeButton != null) {
                    WindowsTitlePane.this.closeButton.setBounds(0, 0, 0, 0);
                }
                if (WindowsTitlePane.this.minimizeButton != null) {
                    WindowsTitlePane.this.minimizeButton.setBounds(0, 0, 0, 0);
                }
                if (WindowsTitlePane.this.maximizeToggleButton != null) {
                    WindowsTitlePane.this.maximizeToggleButton.setBounds(0, 0, 0, 0);
                }
                if (WindowsTitlePane.this.titleLabel != null) {
                    WindowsTitlePane.this.titleLabel.setBounds(0, 0, 0, 0);
                }
                return;
            }
            boolean leftToRight = WindowsTitlePane.this.isLeftToRight(WindowsTitlePane.this.window);
            int w = WindowsTitlePane.this.getWidth();
            int start = 0;
            int y = 0;
            int height = this.computeHeight();
            int left = 0;
            int right = 0;
            if (WindowsTitlePane.this.windowIconButton != null) {
                int windowButtonWidth = WindowsTitlePane.this.windowIconButton.getIcon() != null ? Math.max(WindowsTitlePane.this.windowIconButton.getIcon().getIconHeight(), WindowsTitlePane.this.windowIconButton.getIcon().getIconWidth()) : 32;
                windowButtonWidth = Math.min(32, windowButtonWidth);
                WindowsTitlePane.this.windowIconButton.setBounds(start + 2, y, windowButtonWidth, height);
                left = start += windowButtonWidth + 5;
            }
            if (WindowsTitlePane.this.menuBar != null) {
                int menuWidth = this.getPreferredMenuSize().width;
                Insets menuInsets = WindowsTitlePane.this.menuBar.getInsets();
                WindowsTitlePane.this.menuBar.setBounds(start, y, menuWidth, height + menuInsets.bottom);
                start += menuWidth + 5;
                left += menuWidth;
            }
            int x = w;
            if (WindowsTitlePane.this.closeButton != null) {
                right += 46;
                WindowsTitlePane.this.closeButton.setBounds(x -= 46, y, 46, height);
            }
            if (WindowsTitlePane.this.getWindowDecorationStyle() == 1 && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                if (WindowsTitlePane.this.maximizeToggleButton != null && WindowsTitlePane.this.maximizeToggleButton.getParent() != null) {
                    right += 46;
                    WindowsTitlePane.this.maximizeToggleButton.setBounds(x -= 46, y, 46, height);
                }
                if (WindowsTitlePane.this.minimizeButton != null && WindowsTitlePane.this.minimizeButton.getParent() != null) {
                    right += 46;
                    WindowsTitlePane.this.minimizeButton.setBounds(x -= 46, y, 46, height);
                }
            }
            start = Math.max(start, 5);
            WindowsTitlePane.this.titleLabel.setBounds(start, 0, x - start - 5, height);
            if (!leftToRight) {
                this.mirror(WindowsTitlePane.this.windowIconButton, w);
                this.mirror(WindowsTitlePane.this.menuBar, w);
                this.mirror(WindowsTitlePane.this.closeButton, w);
                this.mirror(WindowsTitlePane.this.minimizeButton, w);
                this.mirror(WindowsTitlePane.this.maximizeToggleButton, w);
                this.mirror(WindowsTitlePane.this.titleLabel, w);
                int tmp = left;
                left = right;
                right = tmp;
            }
            JNIDecorationsWindows.updateValues(WindowsTitlePane.this.windowHandle, Scale.scaleWidth(left), Scale.scaleWidth(right), Scale.scaleHeight(height));
        }

        private void mirror(JComponent component, int w) {
            if (component != null) {
                component.setLocation(w - component.getX() - component.getWidth(), component.getY());
            }
        }

        private Dimension getPreferredMenuSize() {
            LayoutManager menuBarLayout = WindowsTitlePane.this.menuBar.getLayout();
            Dimension size = null;
            if (menuBarLayout != null) {
                size = menuBarLayout.preferredLayoutSize(WindowsTitlePane.this.menuBar);
            }
            return size != null ? size : WindowsTitlePane.this.menuBar.getPreferredSize();
        }
    }
}

