/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.DarkSVGIcon;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;

public class RotatableIcon
implements Icon {
    private Icon icon;
    private Alignment alignment;

    public RotatableIcon() {
        this(null);
    }

    public RotatableIcon(Icon icon) {
        this.setIcon(icon);
        this.setOrientation(null);
    }

    public void setIcon(Icon icon) {
        this.icon = icon == null ? EmptyIcon.create(0) : icon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon instanceof DarkSVGIcon) {
            ((DarkSVGIcon)this.icon).paintIcon(c, g, x, y, this.getAngle());
        } else if (this.icon != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            AffineTransform transform = new AffineTransform();
            transform.rotate(this.getAngle(), (double)x + (double)this.getIconWidth() / 2.0, (double)y + (double)this.getIconHeight() / 2.0);
            g2.transform(transform);
            this.icon.paintIcon(c, g2, x, y);
        }
    }

    private double getAngle() {
        double angle = 0.0;
        switch (this.alignment) {
            case NORTH: 
            case CENTER: {
                angle = 0.0;
                break;
            }
            case SOUTH: {
                angle = 180.0;
                break;
            }
            case EAST: {
                angle = 90.0;
                break;
            }
            case WEST: {
                angle = 270.0;
                break;
            }
            case NORTH_EAST: {
                angle = 45.0;
                break;
            }
            case NORTH_WEST: {
                angle = 315.0;
                break;
            }
            case SOUTH_EAST: {
                angle = 135.0;
                break;
            }
            case SOUTH_WEST: {
                angle = 225.0;
            }
        }
        return Math.toRadians(angle);
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    public Alignment getOrientation() {
        return this.alignment;
    }

    public void setOrientation(Alignment alignment) {
        this.alignment = alignment != null ? alignment : Alignment.NORTH;
    }
}

