/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class MutableLineBorder
extends AbstractBorder {
    private Color color;
    protected int top;
    protected int left;
    protected int right;
    protected int bottom;

    public MutableLineBorder(int top, int left, int bottom, int right, Color color) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.color = color;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.getColor());
        g.fillRect(x, y, width - this.right, this.top);
        g.fillRect(x, y + this.top, this.left, height - this.top);
        g.fillRect(x + this.left, y + height - this.bottom, width - this.left, this.bottom);
        g.fillRect(x + width - this.right, y, this.right, height - this.bottom);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    protected Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.setTop(top);
        this.setBottom(bottom);
        this.setLeft(left);
        this.setRight(right);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this.left;
        insets.top = this.top;
        insets.right = this.right;
        insets.bottom = this.bottom;
        return insets;
    }

    public Insets getBorderInsets() {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public static class UIResource
    extends MutableLineBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(int top, int left, int bottom, int right, Color color) {
            super(top, left, bottom, right, color);
        }
    }
}

