/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.wavelet;

import boofcv.struct.wavelet.WlBorderCoef;
import boofcv.struct.wavelet.WlCoef;

public class WlBorderCoefFixed<T extends WlCoef>
implements WlBorderCoef<T> {
    public T[] lowerCoef;
    public T[] upperCoef;
    T innerCoef;

    public WlBorderCoefFixed(int numLower, int numUpper) {
        this.lowerCoef = new WlCoef[numLower];
        this.upperCoef = new WlCoef[numUpper];
    }

    public void setInnerCoef(T innerCoef) {
        this.innerCoef = innerCoef;
    }

    public T getLower(int index) {
        return this.lowerCoef[index];
    }

    public T getUpper(int index) {
        return this.upperCoef[index];
    }

    public void setLower(int index, T coef) {
        this.lowerCoef[index] = coef;
    }

    public void setUpper(int index, T coef) {
        this.upperCoef[index] = coef;
    }

    @Override
    public int getLowerLength() {
        return this.lowerCoef.length;
    }

    @Override
    public int getUpperLength() {
        return this.upperCoef.length;
    }

    @Override
    public T getBorderCoefficients(int index) {
        if (index >= 0) {
            int i = index / 2;
            if (i < this.lowerCoef.length) {
                return this.lowerCoef[i];
            }
            return this.innerCoef;
        }
        if ((index = -index / 2 - 1) < this.upperCoef.length) {
            return this.upperCoef[index];
        }
        return this.innerCoef;
    }

    @Override
    public T getInnerCoefficients() {
        return this.innerCoef;
    }
}

