/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.packed;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import georegression.struct.point.Point4D_F32;
import org.ddogleg.struct.DogArray_F32;

public class PackedArrayPoint4D_F32
implements PackedArray<Point4D_F32> {
    private static final int DOF = 4;
    public final DogArray_F32 array;
    public final Point4D_F32 temp = new Point4D_F32();
    protected int numElements;

    public PackedArrayPoint4D_F32() {
        this.array = new DogArray_F32();
        this.array.resize(0);
    }

    @Override
    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    @Override
    public void reserve(int numTuples) {
        this.array.reserve(numTuples * 4);
    }

    @Override
    public void append(Point4D_F32 element) {
        this.array.add(element.x);
        this.array.add(element.y);
        this.array.add(element.z);
        this.array.add(element.w);
        ++this.numElements;
    }

    @Override
    public Point4D_F32 getTemp(int index) {
        this.temp.x = this.array.data[index *= 4];
        this.temp.y = this.array.data[index + 1];
        this.temp.z = this.array.data[index + 2];
        this.temp.w = this.array.data[index + 3];
        return this.temp;
    }

    @Override
    public void getCopy(int index, Point4D_F32 dst) {
        dst.x = this.array.data[index *= 4];
        dst.y = this.array.data[index + 1];
        dst.z = this.array.data[index + 2];
        dst.w = this.array.data[index + 3];
    }

    @Override
    public void copy(Point4D_F32 src, Point4D_F32 dst) {
        dst.setTo(src);
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public Class<Point4D_F32> getElementType() {
        return Point4D_F32.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<Point4D_F32> op) {
        int pointIndex = idx0;
        idx1 *= 4;
        for (int i = idx0 *= 4; i < idx1; i += 4) {
            this.temp.x = this.array.data[i];
            this.temp.y = this.array.data[i + 1];
            this.temp.z = this.array.data[i + 2];
            this.temp.w = this.array.data[i + 3];
            op.process(pointIndex++, this.temp);
        }
    }
}

