/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.struct.FactoryTupleDesc;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_U8;
import boofcv.struct.kmeans.ComputeMeanTuple_F32;
import boofcv.struct.kmeans.ComputeMeanTuple_F64;
import boofcv.struct.kmeans.ComputeMeanTuple_MT_F32;
import boofcv.struct.kmeans.ComputeMeanTuple_MT_F64;
import boofcv.struct.kmeans.ComputeMeanTuple_MT_U8;
import boofcv.struct.kmeans.ComputeMeanTuple_U8;
import boofcv.struct.kmeans.ComputeMedianTuple_B;
import boofcv.struct.kmeans.TuplePointDistanceEuclideanSq;
import boofcv.struct.kmeans.TuplePointDistanceHamming;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.clustering.ConfigKMeans;
import org.ddogleg.clustering.FactoryClustering;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.clustering.kmeans.StandardKMeans;

public class FactoryTupleCluster {
    public static <TD extends TupleDesc<TD>> StandardKMeans<TD> kmeans(ConfigKMeans config, int minimumForThreads, int numElements, Class<TD> tupleType) {
        config.checkValidity();
        if (BoofConcurrency.isUseConcurrent()) {
            return FactoryClustering.kMeans_MT(config, minimumForThreads, FactoryTupleCluster.createMeanClusters(numElements, minimumForThreads, tupleType), FactoryTupleCluster.createDistance(tupleType), () -> FactoryTupleDesc.createTuple(numElements, tupleType));
        }
        return FactoryClustering.kMeans(config, FactoryTupleCluster.createMeanClusters(numElements, minimumForThreads, tupleType), FactoryTupleCluster.createDistance(tupleType), () -> FactoryTupleDesc.createTuple(numElements, tupleType));
    }

    public static <TD extends TupleDesc<TD>> ComputeMeanClusters<TD> createMeanClusters(int numElements, int minimumForThreads, Class<TD> type) {
        if (type == TupleDesc_F64.class) {
            if (BoofConcurrency.isUseConcurrent()) {
                ComputeMeanTuple_MT_F64 mean = new ComputeMeanTuple_MT_F64(numElements);
                mean.setMinimumForConcurrent(minimumForThreads);
                return mean;
            }
            return new ComputeMeanTuple_F64();
        }
        if (type == TupleDesc_F32.class) {
            if (BoofConcurrency.isUseConcurrent()) {
                ComputeMeanTuple_MT_F32 mean = new ComputeMeanTuple_MT_F32(numElements);
                mean.setMinimumForConcurrent(minimumForThreads);
                return mean;
            }
            return new ComputeMeanTuple_F32();
        }
        if (type == TupleDesc_U8.class) {
            if (BoofConcurrency.isUseConcurrent()) {
                ComputeMeanTuple_MT_U8 mean = new ComputeMeanTuple_MT_U8(numElements);
                mean.setMinimumForConcurrent(minimumForThreads);
                return mean;
            }
            return new ComputeMeanTuple_U8(numElements);
        }
        if (type == TupleDesc_B.class) {
            return new ComputeMedianTuple_B(numElements);
        }
        throw new IllegalArgumentException("Unknown");
    }

    public static <TD extends TupleDesc<TD>> PointDistance<TD> createDistance(Class<TD> tuple) {
        if (tuple == TupleDesc_F64.class) {
            return new TuplePointDistanceEuclideanSq.F64();
        }
        if (tuple == TupleDesc_F32.class) {
            return new TuplePointDistanceEuclideanSq.F32();
        }
        if (tuple == TupleDesc_U8.class) {
            return new TuplePointDistanceEuclideanSq.U8();
        }
        if (tuple == TupleDesc_B.class) {
            return new TuplePointDistanceHamming();
        }
        throw new IllegalArgumentException("Add appropriate distance");
    }
}

