/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.GrayF;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import org.jetbrains.annotations.Nullable;

public enum ImageDataType {
    U8(false, Byte.TYPE, byte[]::new),
    S8(true, Byte.TYPE, byte[]::new),
    U16(false, Short.TYPE, short[]::new),
    S16(true, Short.TYPE, short[]::new),
    S32(true, Integer.TYPE, int[]::new),
    S64(true, Long.TYPE, long[]::new),
    F32(true, Float.TYPE, float[]::new),
    F64(true, Double.TYPE, double[]::new),
    I8(Byte.TYPE),
    I16(Short.TYPE),
    I(true),
    F(true);

    private final int numBits;
    private final boolean isAbstract;
    private final boolean isSigned;
    private final boolean isInteger;
    private final double maxValue;
    private final double minValue;
    private final Class dataType;
    private final Class sumType;
    private final CreateArray createArray;

    private ImageDataType(boolean isInteger) {
        this.isAbstract = true;
        this.isInteger = isInteger;
        this.isSigned = false;
        this.numBits = -1;
        this.dataType = Object.class;
        this.sumType = Object.class;
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        this.createArray = i -> {
            throw new RuntimeException("abstract type, no array");
        };
    }

    private ImageDataType(Class dataType) {
        this.isAbstract = true;
        this.dataType = dataType;
        this.isSigned = false;
        this.numBits = this.selectNumBits(dataType);
        this.isInteger = this.selectInteger(dataType);
        this.sumType = this.selectSumType(dataType);
        this.createArray = i -> {
            throw new RuntimeException("abstract type, no array");
        };
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
    }

    private ImageDataType(boolean isSigned, Class dataType, CreateArray createArray) {
        this.isAbstract = false;
        this.isSigned = isSigned;
        this.dataType = dataType;
        this.createArray = createArray;
        this.numBits = this.selectNumBits(dataType);
        this.isInteger = this.selectInteger(dataType);
        this.sumType = this.selectSumType(dataType);
        this.minValue = this.selectMinValue();
        this.maxValue = this.selectMaxValue();
    }

    @Nullable
    public static ImageDataType classToType(Class imageClass) {
        if (imageClass == GrayU8.class) {
            return U8;
        }
        if (imageClass == GrayS8.class) {
            return S8;
        }
        if (imageClass == GrayU16.class) {
            return U16;
        }
        if (imageClass == GrayS16.class) {
            return S16;
        }
        if (imageClass == GrayS32.class) {
            return S32;
        }
        if (imageClass == GrayS64.class) {
            return S64;
        }
        if (imageClass == GrayF32.class) {
            return F32;
        }
        if (imageClass == GrayF64.class) {
            return F64;
        }
        if (imageClass == GrayI8.class) {
            return I8;
        }
        if (imageClass == GrayI16.class) {
            return I16;
        }
        if (imageClass == GrayI.class) {
            return I;
        }
        if (imageClass == GrayF.class) {
            return F;
        }
        if (imageClass == InterleavedU8.class) {
            return U8;
        }
        if (imageClass == InterleavedS8.class) {
            return S8;
        }
        if (imageClass == InterleavedU16.class) {
            return U16;
        }
        if (imageClass == InterleavedS16.class) {
            return S16;
        }
        if (imageClass == InterleavedS32.class) {
            return S32;
        }
        if (imageClass == InterleavedS64.class) {
            return S64;
        }
        if (imageClass == InterleavedF32.class) {
            return F32;
        }
        if (imageClass == InterleavedF64.class) {
            return F64;
        }
        if (imageClass == InterleavedI8.class) {
            return I8;
        }
        if (imageClass == InterleavedI16.class) {
            return I16;
        }
        return null;
    }

    public static Class typeToSingleClass(ImageDataType type) {
        Class clazz;
        switch (type) {
            case U8: {
                clazz = GrayU8.class;
                break;
            }
            case S8: {
                clazz = GrayS8.class;
                break;
            }
            case U16: {
                clazz = GrayU16.class;
                break;
            }
            case S16: {
                clazz = GrayS16.class;
                break;
            }
            case S32: {
                clazz = GrayS32.class;
                break;
            }
            case S64: {
                clazz = GrayS64.class;
                break;
            }
            case F32: {
                clazz = GrayF32.class;
                break;
            }
            case F64: {
                clazz = GrayF64.class;
                break;
            }
            case I8: {
                clazz = GrayI8.class;
                break;
            }
            case I16: {
                clazz = GrayI16.class;
                break;
            }
            case I: {
                clazz = GrayI.class;
                break;
            }
            case F: {
                clazz = GrayF.class;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return clazz;
    }

    public static Class typeToInterleavedClass(ImageDataType type) {
        Class clazz;
        switch (type) {
            case U8: {
                clazz = InterleavedU8.class;
                break;
            }
            case S8: {
                clazz = InterleavedS8.class;
                break;
            }
            case U16: {
                clazz = InterleavedU16.class;
                break;
            }
            case S16: {
                clazz = InterleavedS16.class;
                break;
            }
            case S32: {
                clazz = InterleavedS32.class;
                break;
            }
            case S64: {
                clazz = InterleavedS64.class;
                break;
            }
            case F32: {
                clazz = InterleavedF32.class;
                break;
            }
            case F64: {
                clazz = InterleavedF64.class;
                break;
            }
            case I8: {
                clazz = InterleavedI8.class;
                break;
            }
            case I16: {
                clazz = InterleavedI16.class;
                break;
            }
            default: {
                throw new RuntimeException("Add");
            }
        }
        return clazz;
    }

    private int selectNumBits(Class dataType) {
        if (dataType == Float.TYPE || dataType == Double.TYPE) {
            if (dataType == Float.TYPE) {
                return 32;
            }
            return 64;
        }
        if (dataType == Byte.TYPE) {
            return 8;
        }
        if (dataType == Short.TYPE) {
            return 16;
        }
        if (dataType == Integer.TYPE) {
            return 32;
        }
        if (dataType == Long.TYPE) {
            return 64;
        }
        return -1;
    }

    private boolean selectInteger(Class dataType) {
        return dataType != Float.TYPE && dataType != Double.TYPE;
    }

    private Class selectSumType(Class dataType) {
        if (dataType == Float.TYPE || dataType == Double.TYPE) {
            return dataType;
        }
        if (this.numBits <= 32) {
            return Integer.TYPE;
        }
        return Long.TYPE;
    }

    private double selectMinValue() {
        double d;
        if (this.isInteger && !this.isSigned) {
            return 0.0;
        }
        if (this.isInteger) {
            double d2;
            switch (this.numBits) {
                case 8: {
                    d2 = -128.0;
                    break;
                }
                case 16: {
                    d2 = -32768.0;
                    break;
                }
                case 32: {
                    d2 = -2.147483648E9;
                    break;
                }
                case 64: {
                    d2 = -9.223372036854776E18;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected number of bits for integer type: " + this.numBits);
                }
            }
            return d2;
        }
        switch (this.numBits) {
            case 32: {
                d = -3.4028234663852886E38;
                break;
            }
            case 64: {
                d = -1.7976931348623157E308;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected number of bits for float type: " + this.numBits);
            }
        }
        return d;
    }

    private double selectMaxValue() {
        double d;
        if (this.isInteger) {
            double d2;
            switch (this.numBits) {
                case 8: {
                    d2 = 127.0 - (double)(this.isSigned ? 0 : -128);
                    break;
                }
                case 16: {
                    d2 = 32767.0 - (double)(this.isSigned ? 0 : Short.MIN_VALUE);
                    break;
                }
                case 32: {
                    d2 = 2.147483647E9 - (double)(this.isSigned ? 0 : Integer.MIN_VALUE);
                    break;
                }
                case 64: {
                    d2 = 9.223372036854776E18 - (double)(this.isSigned ? 0L : Long.MIN_VALUE);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected number of bits for integer type: " + this.numBits);
                }
            }
            return d2;
        }
        switch (this.numBits) {
            case 32: {
                d = 3.4028234663852886E38;
                break;
            }
            case 64: {
                d = Double.MAX_VALUE;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected number of bits for float type: " + this.numBits);
            }
        }
        return d;
    }

    public <T> T newArray(int length) {
        return (T)this.createArray.create(length);
    }

    public int getNumBits() {
        return this.numBits;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public Class getSumType() {
        return this.sumType;
    }

    public CreateArray getCreateArray() {
        return this.createArray;
    }

    private static interface CreateArray {
        public Object create(int var1);
    }
}

