/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.concurrency.BoofConcurrency;
import org.ddogleg.struct.DProcess;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.Factory;

public class ImageGrid<T> {
    public final DogArray<T> cells;
    public int rows;
    public int cols;
    public int lengthX;
    public int lengthY;

    public ImageGrid(Factory<T> factory, DProcess<T> reset) {
        this.cells = new DogArray<T>(factory, reset);
    }

    public void initialize(int targetLength, int imageWidth, int imageHeight) {
        this.rows = imageHeight / targetLength + (imageHeight % targetLength > 0 ? 1 : 0);
        this.cols = imageWidth / targetLength + (imageWidth % targetLength > 0 ? 1 : 0);
        this.lengthY = (int)((double)imageHeight / (double)this.rows + 0.5);
        this.lengthX = (int)((double)imageWidth / (double)this.cols + 0.5);
        this.cells.reset();
        this.cells.resize(this.rows * this.cols);
    }

    public T getCellAtPixel(int pixelX, int pixelY) {
        int row = pixelY / this.lengthY;
        int col = pixelX / this.lengthX;
        if (row >= this.rows) {
            row = this.rows - 1;
        }
        if (col >= this.cols) {
            col = this.cols - 1;
        }
        return (T)this.cells.data[row * this.cols + col];
    }

    public T get(int row, int col) {
        return (T)this.cells.data[row * this.cols + col];
    }

    public void processCells(ProcessCell<T> processor) {
        int i = 0;
        for (int row = 0; row < this.rows; ++row) {
            int col = 0;
            while (col < this.cols) {
                processor.process(row, col, this.cells.data[i]);
                ++col;
                ++i;
            }
        }
    }

    public void processCellsThreads(ProcessCell<T> processor) {
        BoofConcurrency.loopFor(0, this.cells.size, cellIdx -> {
            int row = cellIdx / this.cols;
            int col = cellIdx % this.cols;
            processor.process(row, col, this.cells.data[cellIdx]);
        });
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getLengthX() {
        return this.lengthX;
    }

    public int getLengthY() {
        return this.lengthY;
    }

    public static interface ProcessCell<T> {
        public void process(int var1, int var2, T var3);
    }
}

