/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public abstract class ConfigGenerator<Config extends Configuration> {
    int numTrials;
    long seed;
    Class<Config> type;
    int trial;
    protected Random rand;
    protected List<Parameter> parameters = new ArrayList<Parameter>();
    protected Config configurationBase;
    protected Config configCurrent;

    protected ConfigGenerator(long seed, Class<Config> type) {
        this.seed = seed;
        this.type = type;
        try {
            this.configurationBase = (Configuration)type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        this.trial = 0;
        this.rand = new Random(this.seed);
    }

    protected int getNumberOfStates(Parameter p) {
        if (p.getStateSize() == 0) {
            throw new RuntimeException("There are an infinite number of states");
        }
        return p.getStateSize();
    }

    public <E extends Enum<E>> void setOfEnums(String parameter, Enum<E> ... values) {
        this.checkPath(parameter, values[0].getDeclaringClass());
        this.parameters.add(new SetOfObjects(parameter, BoofMiscOps.asList(values)));
    }

    public void setOfIntegers(String parameter, int ... values) {
        this.checkPath(parameter, Integer.TYPE);
        ArrayList<Object> states = new ArrayList<Object>();
        for (int i = 0; i < values.length; ++i) {
            states.add(values[i]);
        }
        this.parameters.add(new SetOfObjects(parameter, states));
    }

    public void setOfFloats(String parameter, double ... values) {
        this.checkPath(parameter, Double.TYPE);
        ArrayList<Object> states = new ArrayList<Object>();
        for (int i = 0; i < values.length; ++i) {
            states.add(values[i]);
        }
        this.parameters.add(new SetOfObjects(parameter, states));
    }

    public void rangeOfIntegers(String parameter, int min, int max) {
        this.checkPath(parameter, Integer.TYPE);
        this.parameters.add(new RangeOfIntegers(parameter, min, max));
    }

    public void rangeOfFloats(String parameter, double min, double max) {
        this.checkPath(parameter, Double.TYPE);
        this.parameters.add(new RangeOfFloats(parameter, min, max));
    }

    public boolean hasNext() {
        return this.trial < this.numTrials;
    }

    public abstract Config next();

    public String toStringSettings() {
        String ret = "type," + this.type.getCanonicalName() + "\n";
        ret = ret + "random_seed," + this.seed + "\n";
        ret = ret + "parameters:\n";
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter p = this.parameters.get(i);
            ret = ret + p.getPath() + "," + p.getDescription() + "\n";
        }
        return ret;
    }

    public String toStringState() {
        String ret = "";
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter p = this.parameters.get(i);
            ret = ret + p.getPath() + "," + ConfigGenerator.getValue(this.configCurrent, p.path) + "\n";
        }
        return ret;
    }

    public Config getConfiguration() {
        return this.configCurrent;
    }

    public static void assignValue(Object config, String path, Object value) {
        try {
            String[] names = path.split("\\.");
            Field field = null;
            Class<?> fieldType = null;
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                field = config.getClass().getField(fieldName);
                fieldType = field.getType();
                if (i + 1 >= names.length) continue;
                config = field.get(config);
            }
            if (fieldType == Float.TYPE && value.getClass() == Double.class) {
                value = Float.valueOf((float)((Double)value).doubleValue());
            } else if (fieldType != value.getClass() && fieldType != value.getClass().getField("TYPE").get(null)) {
                throw new RuntimeException("Unexpected type. path=" + path + " expected=" + value.getClass().getSimpleName() + " found=" + fieldType.getSimpleName());
            }
            Objects.requireNonNull(field).set(config, value);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static Object getValue(Object config, String path) {
        try {
            String[] names = path.split("\\.");
            Field field = null;
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                field = config.getClass().getField(fieldName);
                if (i + 1 >= names.length) continue;
                config = field.get(config);
            }
            return ((Field)Objects.requireNonNull(field)).get(config);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected void checkPath(String parameter, Class<?> variableType) {
        String[] names = parameter.split("\\.");
        if (names.length == 0) {
            throw new IllegalArgumentException("path of length 0. path=" + parameter);
        }
        Class<Object> pathType = this.type;
        try {
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                Field field = pathType.getField(fieldName);
                pathType = field.getType();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        if (pathType == Float.TYPE || pathType == Double.TYPE) {
            if (variableType != Double.TYPE) {
                throw new IllegalArgumentException("Expected floating point but found " + variableType.getSimpleName());
            }
        } else if (variableType != pathType) {
            throw new RuntimeException("Unexpected type. path=" + parameter + " expected=" + variableType.getSimpleName() + " found=" + pathType.getSimpleName());
        }
    }

    public int getNumTrials() {
        return this.numTrials;
    }

    public long getSeed() {
        return this.seed;
    }

    public Class<Config> getType() {
        return this.type;
    }

    public int getTrial() {
        return this.trial;
    }

    public Config getConfigurationBase() {
        return this.configurationBase;
    }

    static abstract class Parameter {
        String path;

        protected Parameter(String path) {
            this.path = path;
        }

        String getPath() {
            return this.path;
        }

        abstract Object selectValue(Random var1);

        abstract Object selectValue(double var1);

        abstract String getDescription();

        abstract int getStateSize();
    }

    static class SetOfObjects
    extends Parameter {
        List<Object> states;

        public SetOfObjects(String path, List<Object> states) {
            super(path);
            this.states = states;
        }

        @Override
        Object selectValue(Random rand) {
            return this.states.get(rand.nextInt(this.states.size()));
        }

        @Override
        Object selectValue(double fraction) {
            return this.states.get(Math.min(this.states.size() - 1, (int)((double)this.states.size() * fraction)));
        }

        @Override
        String getDescription() {
            String typeName = this.states.get(0).getClass().getName();
            String ret = typeName + ",";
            for (int i = 0; i < this.states.size(); ++i) {
                ret = ret + this.states.get(i).toString();
                if (i + 1 == this.states.size()) continue;
                ret = ret + ",";
            }
            return ret;
        }

        @Override
        int getStateSize() {
            return this.states.size();
        }
    }

    static class RangeOfIntegers
    extends Parameter {
        int idx0;
        int idx1;

        public RangeOfIntegers(String path, int idx0, int idx1) {
            super(path);
            this.idx0 = idx0;
            this.idx1 = idx1;
        }

        @Override
        Object selectValue(Random rand) {
            return this.idx0 + rand.nextInt(1 + this.idx1 - this.idx0);
        }

        @Override
        Object selectValue(double fraction) {
            if (fraction >= 1.0) {
                return this.idx1;
            }
            return this.idx0 + (int)((double)(1 + this.idx1 - this.idx0) * fraction);
        }

        @Override
        String getDescription() {
            return "range-integers," + this.idx0 + "," + this.idx1;
        }

        @Override
        int getStateSize() {
            return 0;
        }
    }

    static class RangeOfFloats
    extends Parameter {
        double idx0;
        double idx1;

        public RangeOfFloats(String path, double idx0, double idx1) {
            super(path);
            this.idx0 = idx0;
            this.idx1 = idx1;
        }

        @Override
        Object selectValue(Random rand) {
            return this.idx0 + rand.nextDouble() * (this.idx1 - this.idx0);
        }

        @Override
        Object selectValue(double fraction) {
            return this.idx0 + (this.idx1 - this.idx0) * fraction;
        }

        @Override
        String getDescription() {
            return "range-float," + this.idx0 + "," + this.idx1;
        }

        @Override
        int getStateSize() {
            return 0;
        }
    }
}

