/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class PrintStreamInjectIndent
extends PrintStream {
    public PrintStreamInjectIndent(String prefix, int numIndent, PrintStream out) {
        super(new Injector(out, prefix, numIndent * 2));
    }

    public int getIndentSpaces() {
        return ((Injector)this.out).numSpaces;
    }

    public int getIndentCount() {
        return ((Injector)this.out).numSpaces / 2;
    }

    public PrintStream getOriginalStream() {
        return ((Injector)this.out).out;
    }

    public static class Injector
    extends OutputStream {
        PrintStream out;
        int numSpaces;
        String prefix;
        boolean newLine = true;

        public Injector(PrintStream out, String prefix, int numSpaces) {
            this.out = out;
            this.prefix = prefix;
            this.numSpaces = numSpaces;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.newLine) {
                int i;
                for (i = 0; i < this.prefix.length(); ++i) {
                    this.out.write(this.prefix.charAt(i));
                }
                for (i = 0; i < this.numSpaces; ++i) {
                    this.out.write(32);
                }
                this.newLine = false;
            }
            this.out.write(b);
            if (b == 10) {
                this.newLine = true;
            }
        }
    }
}

