/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.images;

import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;
import java.util.List;

public class LoadFileImageSequence2<T extends ImageBase<T>>
implements SimpleImageSequence<T> {
    int index;
    List<String> paths;
    ImageType<T> type;
    T image;
    T work;
    BufferedImage imageGUI;
    boolean loop = false;
    boolean forwards = true;
    int targetPixels = 0;

    public LoadFileImageSequence2(List<String> paths, ImageType<T> type) {
        this.type = type;
        this.paths = paths;
        this.image = type.createImage(0, 0);
        this.work = type.createImage(0, 0);
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public int getWidth() {
        if (((ImageBase)this.image).width == 0) {
            this.loadImage(this.paths.get(0));
        }
        return ((ImageBase)this.image).getWidth();
    }

    @Override
    public int getHeight() {
        if (((ImageBase)this.image).width == 0) {
            this.loadImage(this.paths.get(0));
        }
        return ((ImageBase)this.image).getHeight();
    }

    @Override
    public boolean hasNext() {
        if (this.loop) {
            return true;
        }
        return this.index < this.paths.size();
    }

    @Override
    public T next() {
        if (this.loop) {
            if (this.forwards) {
                if (this.index >= this.paths.size()) {
                    this.index = this.paths.size() - 1;
                    this.forwards = false;
                }
            } else if (this.index < 0) {
                this.index = 0;
                this.forwards = true;
            }
        }
        String path = this.forwards ? this.paths.get(this.index++) : this.paths.get(this.index--);
        return this.loadImage(path);
    }

    public T loadImage(String path) {
        this.imageGUI = UtilImageIO.loadImage(path);
        if (this.imageGUI == null) {
            throw new RuntimeException("Could not load image at " + path);
        }
        int numPixels = this.imageGUI.getWidth() * this.imageGUI.getHeight();
        if (this.targetPixels <= 0 || numPixels <= this.targetPixels) {
            ConvertBufferedImage.convertFrom(this.imageGUI, this.image, true);
            return this.image;
        }
        ConvertBufferedImage.convertFrom(this.imageGUI, this.work, true);
        double scale = Math.sqrt(this.targetPixels) / Math.sqrt(numPixels);
        ((ImageBase)this.image).reshape((int)(scale * (double)((ImageBase)this.work).width), (int)(scale * (double)((ImageBase)this.work).height));
        AverageDownSampleOps.down(this.work, this.image);
        return this.image;
    }

    public void seek(int index) {
        this.index = index;
    }

    @Override
    public T getImage() {
        return this.image;
    }

    @Override
    public BufferedImage getGuiImage() {
        return this.imageGUI;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }

    @Override
    public int getFrameNumber() {
        return this.index - 1;
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
        this.index = 0;
        this.forwards = true;
        this.image = null;
        this.imageGUI = null;
    }

    public int getTotalImages() {
        return this.paths.size();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getTargetPixels() {
        return this.targetPixels;
    }

    public void setTargetPixels(int targetPixels) {
        this.targetPixels = targetPixels;
    }
}

