/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.images;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LoadFileImageSequence<T extends ImageBase<T>>
implements SimpleImageSequence<T> {
    String directoryName;
    String suffix;
    int index;
    List<String> fileNames = new ArrayList<String>();
    ImageType<T> type;
    T image;
    int scalefactor;
    BufferedImage scaled;
    BufferedImage imageGUI;
    boolean loop = false;
    boolean forwards = true;

    public LoadFileImageSequence(ImageType<T> type, String directory, String suffix) {
        this(type, directory, suffix, 1);
    }

    public LoadFileImageSequence(ImageType<T> type, String directory, String suffix, int scalefactor) {
        this.directoryName = directory;
        this.suffix = suffix;
        this.scalefactor = scalefactor;
        this.type = type;
        this.findImages();
        this.next();
        this.index = 0;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    private void findImages() {
        File dir = new File(this.directoryName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("directory must specify a directory. path = " + this.directoryName);
        }
        this.fileNames.clear();
        File[] files = this.suffix != null ? dir.listFiles(new Filter()) : dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!UtilImageIO.isImage(f)) continue;
            this.fileNames.add(f.getAbsolutePath());
        }
        Collections.sort(this.fileNames);
    }

    @Override
    public int getWidth() {
        return ((ImageBase)this.image).getWidth();
    }

    @Override
    public int getHeight() {
        return ((ImageBase)this.image).getHeight();
    }

    @Override
    public boolean hasNext() {
        if (this.loop) {
            return true;
        }
        return this.index < this.fileNames.size();
    }

    @Override
    public T next() {
        if (this.loop) {
            if (this.forwards) {
                if (this.index >= this.fileNames.size()) {
                    this.index = this.fileNames.size() - 1;
                    this.forwards = false;
                }
            } else if (this.index < 0) {
                this.index = 0;
                this.forwards = true;
            }
        }
        int indexbefore = this.index;
        this.imageGUI = this.forwards ? UtilImageIO.loadImage(this.fileNames.get(this.index++)) : UtilImageIO.loadImage(this.fileNames.get(this.index--));
        if (this.imageGUI == null) {
            throw new RuntimeException("Could not load image at index " + indexbefore);
        }
        this.image = this.type.createImage(this.imageGUI.getWidth(), this.imageGUI.getHeight());
        ConvertBufferedImage.convertFrom(this.imageGUI, this.image, true);
        if (this.scalefactor == 1) {
            return this.image;
        }
        int width = ((ImageBase)this.image).getWidth() / this.scalefactor;
        int height = ((ImageBase)this.image).getHeight() / this.scalefactor;
        if (this.scaled == null || this.scaled.getWidth() != width || this.scaled.getHeight() != height) {
            this.scaled = new BufferedImage(width, height, this.imageGUI.getType());
        }
        Graphics2D g2 = this.scaled.createGraphics();
        AffineTransform affine = new AffineTransform();
        affine.setToScale(1.0 / (double)this.scalefactor, 1.0 / (double)this.scalefactor);
        g2.drawImage(this.imageGUI, affine, null);
        this.imageGUI = this.scaled;
        return this.image;
    }

    @Override
    public T getImage() {
        return this.image;
    }

    @Override
    public BufferedImage getGuiImage() {
        return this.imageGUI;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }

    @Override
    public int getFrameNumber() {
        return this.index - 1;
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
        this.index = 0;
        this.forwards = true;
        this.image = null;
        this.imageGUI = null;
    }

    public int getTotalImages() {
        return this.fileNames.size();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private class Filter
    implements FilenameFilter {
        private Filter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(LoadFileImageSequence.this.suffix);
        }
    }
}

