/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.core.image.GConvertImage;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.LookUpImages;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;
import java.util.List;

public class LookUpImageListByIndex<Image extends ImageBase<Image>>
implements LookUpImages {
    List<Image> images;
    ConvertImage<Image> convert = GConvertImage::convert;

    public LookUpImageListByIndex(List<Image> images) {
        BoofMiscOps.checkTrue(images.size() > 0);
        this.images = images;
    }

    @Override
    public boolean loadShape(String name, ImageDimension shape) {
        int index = Integer.parseInt(name);
        if (index < 0 || index >= this.images.size()) {
            return false;
        }
        ImageBase img = (ImageBase)this.images.get(index);
        shape.setTo(img.width, img.height);
        return true;
    }

    @Override
    public <LT extends ImageBase<LT>> boolean loadImage(String name, LT output) {
        int index = Integer.parseInt(name);
        if (index < 0 || index >= this.images.size()) {
            return false;
        }
        this.convert.convert((ImageBase)this.images.get(index), output);
        return true;
    }

    public void setConvert(ConvertImage<Image> convert) {
        this.convert = convert;
    }

    @FunctionalInterface
    static interface ConvertImage<A> {
        public void convert(A var1, ImageBase var2);
    }
}

