/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.alg.feature.detect.line.LineImageOps;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public class ImageLinePanel
extends ImagePanel {
    public final List<LineSegment2D_F32> lines = new ArrayList<LineSegment2D_F32>();
    Line2D.Double line = new Line2D.Double();

    public ImageLinePanel() {
        this.setScaling(ScaleOptions.DOWN);
    }

    public synchronized void setLines(List<LineParametric2D_F32> lines) {
        this.lines.clear();
        for (LineParametric2D_F32 p : lines) {
            LineSegment2D_F32 s = LineImageOps.convert(p, this.img.getWidth(), this.img.getHeight());
            if (s == null) continue;
            this.lines.add(s);
        }
    }

    public synchronized void setLineSegments(List<LineSegment2D_F32> lines) {
        this.lines.clear();
        this.lines.addAll(lines);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.img == null) {
            return;
        }
        Graphics2D g2 = BoofSwingUtil.antialiasing(g);
        g2.setStroke(new BasicStroke(3.0f));
        for (LineSegment2D_F32 s : this.lines) {
            this.line.x1 = this.scale * (double)s.a.x + this.offsetX;
            this.line.y1 = this.scale * (double)s.a.y + this.offsetY;
            this.line.x2 = this.scale * (double)s.b.x + this.offsetX;
            this.line.y2 = this.scale * (double)s.b.y + this.offsetY;
            g2.setColor(Color.RED);
            g2.draw(this.line);
            g2.setColor(Color.BLUE);
            g2.fillOval((int)this.line.x1 - 1, (int)this.line.y1 - 1, 3, 3);
            g2.fillOval((int)this.line.x2 - 1, (int)this.line.y2 - 1, 3, 3);
        }
    }
}

