/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.gui.StandardAlgConfigPanel;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;

public abstract class ControlPanelSurfDescribe
extends StandardAlgConfigPanel {
    public final ConfigSurfDescribe config;
    public boolean color = false;
    private final JSpinner spinnerLargeGrid;
    private final JSpinner spinnerSubRegion;
    private final JSpinner spinnerWidthKernel;
    private final JCheckBox checkHaar;
    private final JCheckBox checkColor = this.checkbox("Color", this.color, "False use the standard gray scale variant if true then the color variant is used");
    final Listener listener;

    protected ControlPanelSurfDescribe(ConfigSurfDescribe config, Listener listener) {
        this.config = config;
        this.listener = listener;
        this.spinnerLargeGrid = this.spinner(config.widthLargeGrid, 1, 100, 1);
        this.spinnerSubRegion = this.spinner(config.widthSubRegion, 1, 100, 1);
        this.spinnerWidthKernel = this.spinner(config.widthSample, 1.0, 100.0, 1.0);
        this.checkHaar = this.checkbox("Use Haar", config.useHaar, "Use Haar instead of gradient. Haar is used in paper");
        this.addLabeled(this.spinnerLargeGrid, "Large Grid", "Width of large grid in sub-regions");
        this.addLabeled(this.spinnerSubRegion, "Sub Regions", "Points in a sub-region");
        this.addLabeled(this.spinnerWidthKernel, "Kernel Width", "Width of sample point");
        this.addAlignLeft(this.checkHaar);
        this.addAlignLeft(this.checkColor);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerLargeGrid) {
            this.config.widthLargeGrid = ((Number)this.spinnerLargeGrid.getValue()).intValue();
        } else if (source == this.spinnerSubRegion) {
            this.config.widthSubRegion = ((Number)this.spinnerSubRegion.getValue()).intValue();
        } else if (source == this.spinnerWidthKernel) {
            this.config.widthSample = ((Number)this.spinnerWidthKernel.getValue()).intValue();
        } else if (source == this.checkHaar) {
            this.config.useHaar = this.checkHaar.isSelected();
        } else if (source == this.checkColor) {
            this.color = this.checkColor.isSelected();
        } else {
            throw new RuntimeException("Unknown source");
        }
        this.listener.handleChangeDescribeSurf();
    }

    @FunctionalInterface
    public static interface Listener {
        public void handleChangeDescribeSurf();
    }

    public static class Stability
    extends ControlPanelSurfDescribe {
        public ConfigSurfDescribe.Stability config;
        private final JSpinner spinnerOverlap;
        private final JSpinner spinnerLargeGrid;
        private final JSpinner spinnerSubRegion;

        public Stability(ConfigSurfDescribe.Stability config_, Listener listener) {
            super(config_ == null ? new ConfigSurfDescribe.Stability() : config_, listener);
            this.config = (ConfigSurfDescribe.Stability)((ControlPanelSurfDescribe)this).config;
            this.spinnerOverlap = this.spinner(this.config.overLap, 1, 20, 1);
            this.spinnerLargeGrid = this.spinner(this.config.sigmaLargeGrid, 1.0, 20.0, 1.0);
            this.spinnerSubRegion = this.spinner(this.config.sigmaSubRegion, 1.0, 20.0, 1.0);
            this.addLabeled(this.spinnerOverlap, "Overlap", "Number of sample points sub-regions overlap");
            this.addLabeled(this.spinnerLargeGrid, "Sigma-Grid", "Sigma used to weight points in sub-region grid");
            this.addLabeled(this.spinnerSubRegion, "Sigma-Sub", "Sigma used to weight points in large grid");
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerOverlap) {
                this.config.overLap = ((Number)this.spinnerOverlap.getValue()).intValue();
            } else if (source == this.spinnerLargeGrid) {
                this.config.sigmaLargeGrid = ((Number)this.spinnerLargeGrid.getValue()).doubleValue();
            } else if (source == this.spinnerSubRegion) {
                this.config.sigmaSubRegion = ((Number)this.spinnerSubRegion.getValue()).doubleValue();
            } else {
                super.controlChanged(source);
                return;
            }
            this.listener.handleChangeDescribeSurf();
        }
    }

    public static class Speed
    extends ControlPanelSurfDescribe {
        public ConfigSurfDescribe.Fast config;
        private final JSpinner spinnerWeightSigma;

        public Speed(ConfigSurfDescribe.Fast config_, Listener listener) {
            super(config_ == null ? new ConfigSurfDescribe.Fast() : config_, listener);
            this.config = (ConfigSurfDescribe.Fast)((ControlPanelSurfDescribe)this).config;
            this.spinnerWeightSigma = this.spinner(this.config.weightSigma, 0.5, 100.0, 0.5);
            this.addLabeled(this.spinnerWeightSigma, "Weight Sigma");
        }

        @Override
        public void controlChanged(Object source) {
            if (source != this.spinnerWeightSigma) {
                super.controlChanged(source);
                return;
            }
            this.config.weightSigma = ((Number)this.spinnerWeightSigma.getValue()).doubleValue();
            this.listener.handleChangeDescribeSurf();
        }
    }
}

