/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.factory.feature.detect.selector.SelectLimitTypes;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.feature.ControlPanelExtractor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JSpinner;

public class ControlPanelGeneralCorner
extends StandardAlgConfigPanel {
    public final ConfigGeneralDetector config;
    private final ControlPanelExtractor controlExtract;
    private final JSpinner spinnerMaxFeatures;
    private final JComboBox<String> comboSelector;
    private final Listener listener;

    public ControlPanelGeneralCorner(ConfigGeneralDetector config, Listener listener) {
        this.config = config;
        this.listener = listener;
        this.controlExtract = new ControlPanelExtractor(config, listener::handleGeneralCorner);
        this.comboSelector = this.combo(config.selector.type.ordinal(), (Object[])SelectLimitTypes.values());
        this.spinnerMaxFeatures = this.spinner(config.maxFeatures, -1, 9999, 50);
        StandardAlgConfigPanel panelSelector = new StandardAlgConfigPanel();
        panelSelector.addLabeled(this.comboSelector, "Type", "Method used to select points when more have been detected than the maximum allowed");
        panelSelector.addLabeled(this.spinnerMaxFeatures, "Max Feats", "Maximum features it will detect. If < 1 then for no limit");
        panelSelector.setBorder(BorderFactory.createTitledBorder("Selector"));
        this.controlExtract.setBorder(BorderFactory.createTitledBorder("Non-Max"));
        this.add(this.controlExtract);
        this.add(panelSelector);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerMaxFeatures) {
            this.config.maxFeatures = ((Number)this.spinnerMaxFeatures.getValue()).intValue();
        } else if (source == this.comboSelector) {
            this.config.selector.type = SelectLimitTypes.values()[this.comboSelector.getSelectedIndex()];
        }
        this.listener.handleGeneralCorner();
    }

    public ControlPanelExtractor getControlExtract() {
        return this.controlExtract;
    }

    public JSpinner getSpinnerMaxFeatures() {
        return this.spinnerMaxFeatures;
    }

    public JComboBox<String> getComboSelector() {
        return this.comboSelector;
    }

    @FunctionalInterface
    public static interface Listener {
        public void handleGeneralCorner();
    }
}

