/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.gui.BoofSwingUtil;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class JPyramidLevels
extends JPanel
implements ActionListener {
    public final ConfigDiscreteLevels config;
    private boolean isFixedLevels;
    private int numberOfLevels = 4;
    private int minPixels = 40;
    private final JButton bType = new JButton("TEXTAAA");
    private final JFormattedTextField fieldLevels = BoofSwingUtil.createTextField(1, 1, Integer.MAX_VALUE);
    private final JFormattedTextField fieldPixels = BoofSwingUtil.createTextField(1, 1, Integer.MAX_VALUE);
    protected final Listener listener;

    public JPyramidLevels(@Nullable ConfigDiscreteLevels config, Listener listener) {
        this.setLayout(new BoxLayout(this, 0));
        this.config = config == null ? ConfigDiscreteLevels.minSize(40) : config;
        this.listener = listener;
        this.bType.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.bType.setMaximumSize(this.bType.getPreferredSize());
        this.bType.setToolTipText("Toggles between fixed level pyramid and pixels in top of pyramid");
        this.fieldLevels.setToolTipText("Number of levels in the pyramid");
        this.fieldPixels.setToolTipText("Target width/height in the top of pyramid");
        this.fieldLevels.setPreferredSize(new Dimension(80, 22));
        this.fieldLevels.setMaximumSize(this.fieldLevels.getPreferredSize());
        this.fieldPixels.setPreferredSize(this.fieldLevels.getPreferredSize());
        this.fieldPixels.setMaximumSize(this.fieldPixels.getPreferredSize());
        this.isFixedLevels = config.isFixedLevels();
        if (this.isFixedLevels) {
            this.numberOfLevels = config.numLevelsRequested;
        } else {
            this.minPixels = Math.max(config.minWidth, config.minHeight);
        }
        this.fieldLevels.setValue(this.numberOfLevels);
        this.fieldPixels.setValue(this.minPixels);
        this.updateType(this.isFixedLevels);
        this.fieldLevels.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("value")) {
                this.actionPerformed(this.fieldLevels);
            }
        });
        this.fieldPixels.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("value")) {
                this.actionPerformed(this.fieldPixels);
            }
        });
        this.bType.addActionListener(this);
        this.fieldLevels.addActionListener(this);
        this.fieldPixels.addActionListener(this);
    }

    protected void updateType(boolean levels) {
        this.isFixedLevels = levels;
        this.bType.setText(this.isFixedLevels ? "Levels" : "Pixels");
        this.removeAll();
        this.add(this.bType);
        if (levels) {
            this.add(this.fieldLevels);
        } else {
            this.add(this.fieldPixels);
        }
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e.getSource());
    }

    public void actionPerformed(Object source) {
        if (this.bType == source) {
            this.updateType(!this.isFixedLevels);
        } else if (this.fieldLevels == source) {
            this.numberOfLevels = ((Number)this.fieldLevels.getValue()).intValue();
        } else if (this.fieldPixels == source) {
            this.minPixels = ((Number)this.fieldPixels.getValue()).intValue();
        }
        if (this.isFixedLevels) {
            this.config.numLevelsRequested = this.numberOfLevels;
            this.config.minHeight = -1;
            this.config.minWidth = -1;
        } else {
            this.config.numLevelsRequested = -1;
            this.config.minWidth = this.config.minHeight = this.minPixels;
        }
        this.listener.changePyramidLevels();
    }

    public static interface Listener {
        public void changePyramidLevels();
    }
}

