/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.tracker.PointTracker;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.ControlPanelDdaTracker;
import boofcv.gui.controls.ControlPanelHybridTracker;
import boofcv.gui.controls.ControlPanelPointTrackerKlt;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ControlPanelPointTrackers
extends StandardAlgConfigPanel {
    ConfigPointTracker.TrackerType selectedFamily = ConfigPointTracker.TrackerType.KLT;
    JComboBox<String> cFamily;
    JPanel mainPanel = new JPanel(new BorderLayout());
    ControlPanelPointTrackerKlt controlKlt;
    ControlPanelDdaTracker controlDda;
    ControlPanelHybridTracker controlHybrid;
    JComponent previous;
    Listener listener;

    public ControlPanelPointTrackers(Listener listener, ConfigPointTracker config) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.listener = listener;
        ControlPanelPointTrackerKlt controlPanelPointTrackerKlt = config == null ? new ControlPanelPointTrackerKlt(listener::changePointTracker) : (this.controlKlt = new ControlPanelPointTrackerKlt(listener::changePointTracker, config.detDesc.detectPoint.copy(), config.klt.copy()));
        ControlPanelDdaTracker controlPanelDdaTracker = config == null ? new ControlPanelDdaTracker(listener::changePointTracker) : (this.controlDda = new ControlPanelDdaTracker(listener::changePointTracker, config.dda.copy(), config.detDesc.copy(), config.associate.copy()));
        ControlPanelHybridTracker controlPanelHybridTracker = config == null ? new ControlPanelHybridTracker(listener::changePointTracker) : (this.controlHybrid = new ControlPanelHybridTracker(listener::changePointTracker, config.hybrid, config.klt.copy(), config.detDesc.copy(), config.associate.copy()));
        if (config != null) {
            this.selectedFamily = config.typeTracker;
        }
        this.controlDda.initializeControlsGUI();
        this.controlHybrid.initializeControlsGUI();
        this.cFamily = this.combo(this.selectedFamily.ordinal(), (Object[])ConfigPointTracker.TrackerType.values());
        ConfigPointTracker.TrackerType selected = this.selectedFamily;
        this.selectedFamily = null;
        this.changeFamily(selected);
        this.addLabeled(this.cFamily, "Family", "Which high level point tracker type");
        this.add(this.mainPanel);
    }

    public <T extends ImageBase<T>> PointTracker<T> createTracker(ImageType<T> imageType) {
        PointTracker<T> pointTracker;
        switch (this.selectedFamily) {
            case KLT: {
                pointTracker = this.controlKlt.createTracker(imageType);
                break;
            }
            case DDA: {
                pointTracker = this.controlDda.createTracker(imageType);
                break;
            }
            case HYBRID: {
                pointTracker = this.controlHybrid.createTracker(imageType);
                break;
            }
            default: {
                throw new RuntimeException("Not yet supported");
            }
        }
        return pointTracker;
    }

    private void changeFamily(ConfigPointTracker.TrackerType which) {
        StandardAlgConfigPanel standardAlgConfigPanel;
        if (which == this.selectedFamily) {
            return;
        }
        if (this.previous != null) {
            this.mainPanel.remove(this.previous);
        }
        switch (which) {
            case KLT: {
                standardAlgConfigPanel = this.controlKlt;
                break;
            }
            case DDA: {
                standardAlgConfigPanel = this.controlDda;
                break;
            }
            case HYBRID: {
                standardAlgConfigPanel = this.controlHybrid;
                break;
            }
            default: {
                throw new RuntimeException("BUG");
            }
        }
        this.previous = standardAlgConfigPanel;
        this.selectedFamily = which;
        this.mainPanel.add("Center", this.previous);
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.cFamily) {
            this.changeFamily(ConfigPointTracker.TrackerType.values()[this.cFamily.getSelectedIndex()]);
        }
        this.listener.changePointTracker();
    }

    public static interface Listener {
        public void changePointTracker();
    }
}

