/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.fiducial.CalibrationFiducialDetector;
import boofcv.abst.fiducial.QrCodeDetectorPnP;
import boofcv.abst.fiducial.QrCodePreciseDetector;
import boofcv.abst.fiducial.SquareBinary_to_FiducialDetector;
import boofcv.abst.fiducial.SquareImage_to_FiducialDetector;
import boofcv.abst.fiducial.Uchiya_to_FiducialDetector;
import boofcv.abst.fiducial.calib.ConfigChessboardBinary;
import boofcv.abst.fiducial.calib.ConfigChessboardX;
import boofcv.abst.fiducial.calib.ConfigCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.ConfigCircleRegularGrid;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.feature.describe.llah.LlahHasher;
import boofcv.alg.feature.describe.llah.LlahOperations;
import boofcv.alg.fiducial.dots.UchiyaMarkerImageTracker;
import boofcv.alg.fiducial.dots.UchiyaMarkerTracker;
import boofcv.alg.fiducial.qrcode.QrCodePositionPatternDetector;
import boofcv.alg.fiducial.square.DetectFiducialSquareBinary;
import boofcv.alg.fiducial.square.DetectFiducialSquareImage;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetectorPixel;
import boofcv.alg.shapes.ellipse.EdgeIntensityEllipse;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.ConfigFiducialImage;
import boofcv.factory.fiducial.ConfigLlah;
import boofcv.factory.fiducial.ConfigQrCode;
import boofcv.factory.fiducial.ConfigUchiyaMarker;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.geo.ConfigHomography;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.homography.Homography2D_F64;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.jetbrains.annotations.Nullable;

public class FactoryFiducial {
    public static <T extends ImageGray<T>> SquareBinary_to_FiducialDetector<T> squareBinary(ConfigFiducialBinary configFiducial, @Nullable ConfigThreshold configThreshold, Class<T> imageType) {
        if (configThreshold == null) {
            configThreshold = ConfigThreshold.local(ThresholdType.LOCAL_MEAN, 21);
        }
        configFiducial.checkValidity();
        InputToBinary<T> binary = FactoryThresholdBinary.threshold(configThreshold, imageType);
        DetectPolygonBinaryGrayRefine<T> squareDetector = FactoryShapeDetector.polygon(configFiducial.squareDetector, imageType);
        DetectFiducialSquareBinary<T> alg = new DetectFiducialSquareBinary<T>(configFiducial.gridWidth, configFiducial.borderWidthFraction, configFiducial.minimumBlackBorderFraction, binary, squareDetector, imageType);
        alg.setAmbiguityThreshold(configFiducial.ambiguousThreshold);
        return new SquareBinary_to_FiducialDetector<T>(alg, configFiducial.targetWidth);
    }

    public static <T extends ImageGray<T>> SquareImage_to_FiducialDetector<T> squareImage(@Nullable ConfigFiducialImage configFiducial, @Nullable ConfigThreshold configThreshold, Class<T> imageType) {
        if (configFiducial == null) {
            configFiducial = new ConfigFiducialImage();
        }
        if (configThreshold == null) {
            configThreshold = ConfigThreshold.local(ThresholdType.LOCAL_MEAN, 21);
        }
        configFiducial.squareDetector.detector.clockwise = false;
        InputToBinary<T> binary = FactoryThresholdBinary.threshold(configThreshold, imageType);
        DetectPolygonBinaryGrayRefine<T> squareDetector = FactoryShapeDetector.polygon(configFiducial.squareDetector, imageType);
        DetectFiducialSquareImage<T> alg = new DetectFiducialSquareImage<T>(binary, squareDetector, configFiducial.borderWidthFraction, configFiducial.minimumBlackBorderFraction, configFiducial.maxErrorFraction, imageType);
        return new SquareImage_to_FiducialDetector<T>(alg);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibChessboardB(@Nullable ConfigChessboardBinary config, ConfigGridDimen dimen, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, dimen, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibChessboardX(@Nullable ConfigChessboardX config, ConfigGridDimen dimen, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, dimen, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibSquareGrid(@Nullable ConfigSquareGrid config, ConfigGridDimen configDimen, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, configDimen, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibSquareGridBinary(ConfigSquareGridBinary config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibCircleHexagonalGrid(@Nullable ConfigCircleHexagonalGrid config, ConfigGridDimen configDimen, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, configDimen, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibCircleRegularGrid(@Nullable ConfigCircleRegularGrid config, ConfigGridDimen configDimen, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, configDimen, imageType);
    }

    public static <T extends ImageGray<T>> QrCodePreciseDetector<T> qrcode(ConfigQrCode config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigQrCode();
        }
        config.checkValidity();
        InputToBinary<T> inputToBinary = FactoryThresholdBinary.threshold(config.threshold, imageType);
        DetectPolygonBinaryGrayRefine<T> squareDetector = FactoryShapeDetector.polygon(config.polygon, imageType);
        QrCodePositionPatternDetector<T> detectPositionPatterns = new QrCodePositionPatternDetector<T>(squareDetector, config.versionMaximum);
        return new QrCodePreciseDetector<T>(inputToBinary, detectPositionPatterns, config.forceEncoding, false, imageType);
    }

    public static <T extends ImageGray<T>> QrCodeDetectorPnP<T> qrcode3D(ConfigQrCode config, Class<T> imageType) {
        return new QrCodeDetectorPnP<T>(FactoryFiducial.qrcode(config, imageType));
    }

    public static <T extends ImageGray<T>> Uchiya_to_FiducialDetector<T> randomDots(ConfigUchiyaMarker config, Class<T> imageType) {
        LlahHasher hasher;
        config.checkValidity();
        BinaryEllipseDetectorPixel ellipseDetector = new BinaryEllipseDetectorPixel(config.contourRule);
        ellipseDetector.setMaxDistanceFromEllipse(config.maxDistanceFromEllipse);
        ellipseDetector.setMinimumMinorAxis(config.minimumMinorAxis);
        ellipseDetector.setMaxMajorToMinorRatio(config.maxMajorToMinorRatio);
        ellipseDetector.setMinimumContour(config.contourMinimumLength);
        EdgeIntensityEllipse<T> check = new EdgeIntensityEllipse<T>(config.checkEdge.checkRadialDistance, config.checkEdge.numSampleContour, config.checkEdge.minimumEdgeIntensity, imageType);
        InputToBinary<T> inputToBinary = FactoryThresholdBinary.threshold(config.threshold, imageType);
        ConfigLlah llah = config.llah;
        switch (config.llah.hashType) {
            case AFFINE: {
                hasher = new LlahHasher.Affine(llah.quantizationK, llah.hashTableSize);
                break;
            }
            case CROSS_RATIO: {
                hasher = new LlahHasher.CrossRatio(llah.quantizationK, llah.hashTableSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hash type " + (Object)((Object)config.llah.hashType));
            }
        }
        LlahOperations ops = new LlahOperations(config.llah.numberOfNeighborsN, config.llah.sizeOfCombinationM, hasher);
        Ransac<Homography2D_F64, AssociatedPair> ransac = FactoryMultiViewRobust.homographyRansac(new ConfigHomography(false), config.ransac);
        UchiyaMarkerTracker uchiya = new UchiyaMarkerTracker(ops, ransac);
        UchiyaMarkerImageTracker<T> tracker = new UchiyaMarkerImageTracker<T>(inputToBinary, ellipseDetector, check, uchiya);
        return new Uchiya_to_FiducialDetector<T>(tracker, config.markerWidth, config.markerHeight, ImageType.single(imageType));
    }
}

