/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detdesc;

import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.detdesc.ConfigCompleteSift;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.orientation.ConfigSiftOrientation;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detdesc.CompleteSift;
import boofcv.alg.feature.detdesc.CompleteSift_MT;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.struct.image.GrayF32;
import org.jetbrains.annotations.Nullable;

public class FactoryDetectDescribeAlgs {
    public static CompleteSift sift(@Nullable ConfigCompleteSift config) {
        if (config == null) {
            config = new ConfigCompleteSift();
        }
        ConfigSiftScaleSpace configSS = config.scaleSpace;
        ConfigSiftDetector configDetector = config.detector;
        ConfigSiftOrientation configOri = config.orientation;
        ConfigSiftDescribe configDesc = config.describe;
        SiftScaleSpace ss = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        SiftDetector detector = FactoryInterestPointAlgs.sift(configDetector);
        detector.maxFeaturesAll = configDetector.maxFeaturesAll;
        if (BoofConcurrency.USE_CONCURRENT) {
            return new CompleteSift_MT(ss, detector, () -> new OrientationHistogramSift<GrayF32>(configOri.histogramSize, configOri.sigmaEnlarge, GrayF32.class), () -> new DescribePointSift<GrayF32>(configDesc.widthSubregion, configDesc.widthGrid, configDesc.numHistogramBins, configDesc.sigmaToPixels, configDesc.weightingSigmaFraction, configDesc.maxDescriptorElementValue, GrayF32.class));
        }
        OrientationHistogramSift<GrayF32> orientation = new OrientationHistogramSift<GrayF32>(configOri.histogramSize, configOri.sigmaEnlarge, GrayF32.class);
        DescribePointSift<GrayF32> describe = new DescribePointSift<GrayF32>(configDesc.widthSubregion, configDesc.widthGrid, configDesc.numHistogramBins, configDesc.sigmaToPixels, configDesc.weightingSigmaFraction, configDesc.maxDescriptorElementValue, GrayF32.class);
        return new CompleteSift(ss, detector, orientation, describe);
    }
}

