/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.distort;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.LensDistortionWideFOV;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.distort.universal.LensDistortionUniversalOmni;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.CameraUniversalOmni;

public class LensDistortionFactory {
    public static LensDistortionNarrowFOV narrow(CameraModel param) {
        if (param instanceof CameraPinholeBrown) {
            CameraPinholeBrown c = (CameraPinholeBrown)param;
            if (c.isDistorted()) {
                return new LensDistortionBrown(c);
            }
            return new LensDistortionPinhole(c);
        }
        if (param instanceof CameraPinhole) {
            CameraPinhole c = (CameraPinhole)param;
            return new LensDistortionPinhole(c);
        }
        throw new IllegalArgumentException("Unknown camera model " + param.getClass().getSimpleName());
    }

    public static LensDistortionWideFOV wide(CameraModel param) {
        if (param instanceof CameraUniversalOmni) {
            return new LensDistortionUniversalOmni((CameraUniversalOmni)param);
        }
        throw new IllegalArgumentException("Unknown camera model " + param.getClass().getSimpleName());
    }
}

