/*
 * Decompiled with CFR 0.152.
 */
package boofcv.deepboof;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class ClipAndReduce<T extends ImageBase<T>> {
    T clipped;
    PixelTransformAffine_F32 transform = new PixelTransformAffine_F32();
    ImageDistort<T, T> distort;
    boolean clip;

    public ClipAndReduce(boolean clip, ImageType<T> imageType) {
        this.clip = clip;
        InterpolatePixel<T> interp = FactoryInterpolation.createPixel(0.0, 255.0, InterpolationType.BILINEAR, BorderType.EXTENDED, imageType);
        this.distort = FactoryDistort.distort(false, interp, imageType);
        this.distort.setModel(this.transform);
    }

    public void massage(T input, T output) {
        if (this.clip) {
            T inputAdjusted = this.clipInput(input, output);
            this.transform.getModel().a11 = (float)((ImageBase)input).width / (float)((ImageBase)output).width;
            this.transform.getModel().a22 = (float)((ImageBase)input).height / (float)((ImageBase)output).height;
            this.distort.apply(inputAdjusted, output);
        } else {
            this.transform.getModel().a11 = (float)((ImageBase)input).width / (float)((ImageBase)output).width;
            this.transform.getModel().a22 = (float)((ImageBase)input).height / (float)((ImageBase)output).height;
            this.distort.apply(input, output);
        }
    }

    T clipInput(T input, T output) {
        double ratioInput = (double)((ImageBase)input).width / (double)((ImageBase)input).height;
        double ratioOutput = (double)((ImageBase)output).width / (double)((ImageBase)output).height;
        T a = input;
        if (ratioInput > ratioOutput) {
            int width = ((ImageBase)input).height * ((ImageBase)output).width / ((ImageBase)output).height;
            int x0 = (((ImageBase)input).width - width) / 2;
            int x1 = x0 + width;
            a = this.clipped = ((ImageBase)input).subimage(x0, 0, x1, ((ImageBase)input).height, this.clipped);
        } else if (ratioInput < ratioOutput) {
            int height = ((ImageBase)input).width * ((ImageBase)output).height / ((ImageBase)output).width;
            int y0 = (((ImageBase)input).height - height) / 2;
            int y1 = y0 + height;
            a = this.clipped = ((ImageBase)input).subimage(0, y0, ((ImageBase)input).width, y1, this.clipped);
        }
        return a;
    }
}

