/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding;

import boofcv.concurrency.BoofConcurrency;
import boofcv.core.encoding.impl.ImplConvertYuyv;
import boofcv.core.encoding.impl.ImplConvertYuyv_MT;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ConvertYuyv {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void yuyvToBoof(byte[] data, int width, int height, ImageBase output) {
        if (output instanceof Planar) {
            Planar pl = (Planar)output;
            pl.reshape(width, height, 3);
            if (BoofConcurrency.USE_CONCURRENT) {
                if (pl.getBandType() == GrayU8.class) {
                    ImplConvertYuyv_MT.yuyvToPlanarRgb_U8(data, pl);
                    return;
                } else {
                    if (pl.getBandType() != GrayF32.class) throw new IllegalArgumentException("Unsupported output band format");
                    ImplConvertYuyv_MT.yuyvToPlanarRgb_F32(data, pl);
                }
                return;
            } else if (pl.getBandType() == GrayU8.class) {
                ImplConvertYuyv.yuyvToPlanarRgb_U8(data, pl);
                return;
            } else {
                if (pl.getBandType() != GrayF32.class) throw new IllegalArgumentException("Unsupported output band format");
                ImplConvertYuyv.yuyvToPlanarRgb_F32(data, pl);
            }
            return;
        } else if (output instanceof ImageGray) {
            if (output.getClass() == GrayU8.class) {
                ConvertYuyv.yuyvToGray(data, width, height, (GrayU8)output);
                return;
            } else {
                if (output.getClass() != GrayF32.class) throw new IllegalArgumentException("Unsupported output type");
                ConvertYuyv.yuyvToGray(data, width, height, (GrayF32)output);
            }
            return;
        } else {
            if (!(output instanceof ImageInterleaved)) throw new IllegalArgumentException("Boofcv image type not yet supported");
            ((ImageMultiBand)output).reshape(width, height, 3);
            if (BoofConcurrency.USE_CONCURRENT) {
                if (output.getClass() == InterleavedU8.class) {
                    ImplConvertYuyv_MT.yuyvToInterleaved(data, (InterleavedU8)output);
                    return;
                } else {
                    if (output.getClass() != InterleavedF32.class) throw new IllegalArgumentException("Unsupported output type");
                    ImplConvertYuyv_MT.yuyvToInterleaved(data, (InterleavedF32)output);
                }
                return;
            } else if (output.getClass() == InterleavedU8.class) {
                ImplConvertYuyv.yuyvToInterleaved(data, (InterleavedU8)output);
                return;
            } else {
                if (output.getClass() != InterleavedF32.class) throw new IllegalArgumentException("Unsupported output type");
                ImplConvertYuyv.yuyvToInterleaved(data, (InterleavedF32)output);
            }
        }
    }

    public static GrayU8 yuyvToGray(byte[] data, int width, int height, GrayU8 output) {
        if (output != null) {
            output.reshape(width, height);
        } else {
            output = new GrayU8(width, height);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertYuyv_MT.yuyvToGray(data, output);
        } else {
            ImplConvertYuyv.yuyvToGray(data, output);
        }
        return output;
    }

    public static GrayF32 yuyvToGray(byte[] data, int width, int height, GrayF32 output) {
        if (output != null) {
            output.reshape(width, height);
        } else {
            output = new GrayF32(width, height);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertYuyv_MT.yuyvToGray(data, output);
        } else {
            ImplConvertYuyv.yuyvToGray(data, output);
        }
        return output;
    }
}

