/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.video;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.structure.EpipolarScore3D;
import boofcv.factory.structure.ConfigSelectFrames3D;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class SelectFramesForReconstruction3D<T extends ImageBase<T>>
implements VerbosePrint {
    public final ConfigSelectFrames3D config = new ConfigSelectFrames3D();
    private final DogArray_I32 selectedFrames = new DogArray_I32();
    @Nullable
    PointTracker<T> tracker;
    final DescribePointRadiusAngle<T, TupleDesc_F64> descriptor;
    @Nullable
    AssociateDescription2D<TupleDesc_F64> associate;
    @Nullable
    EpipolarScore3D scorer;
    public final DogArray_I32 inlierIdx = new DogArray_I32();
    private double frameMotion;
    private boolean considered3D;
    private boolean sufficientFeaturePairs;
    private Cause cause = Cause.UNKNOWN;
    CameraPinholeBrown cameraA = new CameraPinholeBrown();
    CameraPinholeBrown cameraB = new CameraPinholeBrown();
    DMatrixRMaj fundamental = new DMatrixRMaj(3, 3);
    int frameNumber;
    int keyFrameNumber;
    boolean forceKeyFrame;
    int width;
    int height;
    final List<PointTrack> activeTracks = new ArrayList<PointTrack>();
    final DogArray<AssociatedPair> pairs = new DogArray<AssociatedPair>(AssociatedPair::new);
    final Frame keyFrame;
    final Frame currentFrame;
    final DogArray_F64 distances = new DogArray_F64();
    @Nullable
    PrintStream verbose = null;

    public SelectFramesForReconstruction3D(DescribePointRadiusAngle<T, TupleDesc_F64> descriptor) {
        this.descriptor = descriptor;
        this.keyFrame = new Frame();
        this.currentFrame = new Frame();
    }

    public void initialize(int width, int height) {
        BoofMiscOps.checkTrue(this.tracker != null, "You must assign tracker a value");
        BoofMiscOps.checkTrue(this.associate != null, "You must assign associate a value");
        BoofMiscOps.checkTrue(this.scorer != null, "You must assign scorer a value");
        this.width = width;
        this.height = height;
        this.tracker.reset();
        this.associate.initialize(width, height);
        this.forceKeyFrame = true;
        this.frameNumber = 0;
        this.selectedFrames.reset();
        PerspectiveOps.createIntrinsic(width, height, 90.0, this.cameraA);
        PerspectiveOps.createIntrinsic(width, height, 90.0, this.cameraB);
    }

    public boolean next(T image) {
        BoofMiscOps.checkEq(((ImageBase)image).width, this.width, "Width does not match.");
        BoofMiscOps.checkEq(((ImageBase)image).height, this.height, "Height does not match.");
        this.frameMotion = Double.NaN;
        this.considered3D = false;
        this.sufficientFeaturePairs = false;
        this.cause = Cause.UNKNOWN;
        this.performTracking(image);
        this.copyTrackResultsIntoCurrentFrame(image);
        boolean saveImage = false;
        if (this.forceKeyFrame) {
            this.cause = Cause.FORCED;
            this.forceKeyFrame = false;
            saveImage = true;
        } else {
            this.createPairsWithKeyFrameTracking(this.keyFrame, this.currentFrame);
            if (this.pairs.size < this.config.minimumPairs) {
                this.cause = Cause.TRACKING_FAILURE;
                saveImage = true;
                if (this.verbose != null) {
                    this.verbose.printf("Too few pairs. pairs.size=%d, key.size=%d current.size=%d\n", this.pairs.size, this.keyFrame.size(), this.currentFrame.size());
                }
            } else {
                this.sufficientFeaturePairs = true;
                this.frameMotion = this.computeFrameRelativeMotion();
                double minMotionThresh = this.config.minTranslation.computeI(Math.max(this.width, this.height));
                double maxMotionThresh = this.config.maxTranslation.computeI(Math.max(this.width, this.height));
                if (this.verbose != null) {
                    this.verbose.printf("_ Motion: distance=%.1f min=%.1f max=%.1f\n", this.frameMotion, minMotionThresh, maxMotionThresh);
                }
                if (this.frameMotion >= minMotionThresh) {
                    if (this.frameMotion > maxMotionThresh) {
                        this.cause = Cause.EXCESSIVE_MOTION;
                        saveImage = true;
                    } else if (!this.isSceneStatic()) {
                        this.considered3D = saveImage = this.isScene3D();
                        if (saveImage) {
                            this.cause = Cause.TRANSLATION_3D;
                        } else {
                            saveImage = this.checkSkippedBadFrame();
                        }
                    }
                }
            }
        }
        if (this.verbose != null) {
            this.verbose.println("saveImage=" + saveImage + " cause=" + (Object)((Object)this.cause));
        }
        if (saveImage) {
            this.keyFrameNumber = this.frameNumber;
            this.selectedFrames.add(this.frameNumber);
            this.keyFrame.setTo(this.currentFrame);
            Objects.requireNonNull(this.associate).setSource(this.keyFrame.locations, this.keyFrame.descriptions);
            if (this.verbose != null) {
                this.verbose.printf("key_frame: total=%d / %d\n", this.selectedFrames.size, this.frameNumber);
            }
        }
        ++this.frameNumber;
        return saveImage;
    }

    public void lookupKeyFrameTracksInCurrentFrame(DogArray<Point2D_F64> tracks) {
        tracks.reset();
        tracks.resize(this.pairs.size);
        for (int i = 0; i < this.pairs.size; ++i) {
            ((Point2D_F64)tracks.get(i)).setTo(((AssociatedPair)this.pairs.get((int)i)).p1);
        }
    }

    protected void performTracking(T frame) {
        Objects.requireNonNull(this.tracker, "Need to specify tracker. Did you call initialize too?");
        this.tracker.process(frame);
        this.tracker.spawnTracks();
        this.tracker.getAllTracks(this.activeTracks);
    }

    protected void copyTrackResultsIntoCurrentFrame(T image) {
        this.descriptor.setImage(image);
        int featureRadius = this.config.featureRadius.computeI(Math.max(this.width, this.height));
        this.currentFrame.reserve(this.activeTracks.size());
        for (int i = 0; i < this.activeTracks.size(); ++i) {
            PointTrack t = this.activeTracks.get(i);
            this.currentFrame.trackID_to_index.put(t.featureId, i);
            this.currentFrame.locations.grow().setTo(t.pixel);
            this.descriptor.process(t.pixel.x, t.pixel.y, 0.0, featureRadius, this.currentFrame.descriptions.grow());
        }
        if (this.verbose != null) {
            this.verbose.printf("current_frame: tracks=%4d frame=%d\n", this.activeTracks.size(), this.frameNumber);
        }
    }

    protected void createPairsWithKeyFrameTracking(Frame keyFrame, Frame current) {
        this.pairs.reset();
        this.pairs.reserve(keyFrame.size());
        keyFrame.trackID_to_index.forEachEntry((trackID, prevIdx) -> {
            int currIdx = current.trackID_to_index.get(trackID);
            if (currIdx < 0) {
                return true;
            }
            AssociatedPair p = this.pairs.grow();
            p.p1.setTo((Point2D_F64)current.locations.get(currIdx));
            p.p2.setTo((Point2D_F64)keyFrame.locations.get(prevIdx));
            return true;
        });
    }

    protected boolean isSceneStatic() {
        double tol = this.config.motionInlierPx * this.config.motionInlierPx;
        int moved = 0;
        for (int pairIdx = 0; pairIdx < this.pairs.size; ++pairIdx) {
            AssociatedPair p = (AssociatedPair)this.pairs.get(pairIdx);
            if (!(p.p1.distance2(p.p2) > tol)) continue;
            ++moved;
        }
        double ratio = (double)moved / (double)this.pairs.size;
        if (this.verbose != null) {
            this.verbose.printf("_ Static: moved=%4d total=%d ratio=%f\n", moved, this.pairs.size, ratio);
        }
        return ratio < this.config.thresholdQuick;
    }

    boolean isScene3D() {
        Objects.requireNonNull(this.scorer);
        this.scorer.process(this.cameraA, this.cameraB, this.keyFrame.size(), this.currentFrame.size(), this.pairs.toList(), this.fundamental, this.inlierIdx);
        return this.scorer.is3D();
    }

    protected boolean checkSkippedBadFrame() {
        boolean skip;
        if (this.config.skipEvidenceRatio < 1.0) {
            return false;
        }
        Objects.requireNonNull(this.associate);
        this.associate.setDestination(this.currentFrame.locations, this.currentFrame.descriptions);
        this.associate.associate();
        FastAccess<AssociatedIndex> matches = this.associate.getMatches();
        boolean bl = skip = (double)matches.size > (double)this.pairs.size * this.config.skipEvidenceRatio;
        if (this.verbose != null) {
            this.verbose.printf("_ Skip: associated=%d tracking=%d skip=%s\n", matches.size, this.pairs.size, skip);
        }
        return skip;
    }

    protected double computeFrameRelativeMotion() {
        this.distances.reset();
        this.distances.resize(this.pairs.size);
        for (int pairIdx = 0; pairIdx < this.pairs.size; ++pairIdx) {
            this.distances.set(pairIdx, ((AssociatedPair)this.pairs.get(pairIdx)).distance2());
        }
        double distance2 = QuickSelect.select(this.distances.data, (int)((double)this.distances.size * 0.9), this.distances.size);
        return Math.sqrt(distance2);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
        BoofMiscOps.verboseChildren(this.verbose, configuration, this.scorer);
    }

    public ConfigSelectFrames3D getConfig() {
        return this.config;
    }

    public DogArray_I32 getSelectedFrames() {
        return this.selectedFrames;
    }

    @Nullable
    public PointTracker<T> getTracker() {
        return this.tracker;
    }

    public void setTracker(@Nullable PointTracker<T> tracker) {
        this.tracker = tracker;
    }

    public DescribePointRadiusAngle<T, TupleDesc_F64> getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public AssociateDescription2D<TupleDesc_F64> getAssociate() {
        return this.associate;
    }

    public void setAssociate(@Nullable AssociateDescription2D<TupleDesc_F64> associate) {
        this.associate = associate;
    }

    @Nullable
    public EpipolarScore3D getScorer() {
        return this.scorer;
    }

    public void setScorer(@Nullable EpipolarScore3D scorer) {
        this.scorer = scorer;
    }

    public DogArray_I32 getInlierIdx() {
        return this.inlierIdx;
    }

    public double getFrameMotion() {
        return this.frameMotion;
    }

    public boolean isConsidered3D() {
        return this.considered3D;
    }

    public boolean isSufficientFeaturePairs() {
        return this.sufficientFeaturePairs;
    }

    public Cause getCause() {
        return this.cause;
    }

    public List<PointTrack> getActiveTracks() {
        return this.activeTracks;
    }

    public DogArray<AssociatedPair> getPairs() {
        return this.pairs;
    }

    public static enum Cause {
        FORCED,
        TRACKING_FAILURE,
        EXCESSIVE_MOTION,
        TRANSLATION_3D,
        UNKNOWN;

    }

    public class Frame {
        public final DogArray<TupleDesc_F64> descriptions = new DogArray<TupleDesc_F64>(SelectFramesForReconstruction3D.this.descriptor::createDescription);
        public final DogArray<Point2D_F64> locations = new DogArray<Point2D_F64>(Point2D_F64::new);
        public final TLongIntMap trackID_to_index = new TLongIntHashMap(10, 0.5f, -1L, -1);

        public int size() {
            return this.descriptions.size;
        }

        public void reserve(int size) {
            this.reset();
            this.descriptions.reserve(size);
            this.locations.reserve(size);
        }

        public void reset() {
            this.descriptions.reset();
            this.locations.reset();
            this.trackID_to_index.clear();
        }

        public void setTo(Frame frame) {
            this.reserve(frame.size());
            for (int i = 0; i < frame.size(); ++i) {
                this.descriptions.grow().setTo((TupleDesc_F64)frame.descriptions.get(i));
                this.locations.grow().setTo((Point2D_F64)frame.locations.get(i));
            }
            frame.trackID_to_index.forEachEntry((key, value) -> {
                this.trackID_to_index.put(key, value);
                return true;
            });
        }
    }
}

