/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.sfot;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.geo.robust.DistanceScaleTranslateRotate2DSq;
import boofcv.alg.geo.robust.GenerateScaleTranslateRotate2D;
import boofcv.alg.geo.robust.ModelManagerScaleTranslateRotate2D;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.alg.tracker.sfot.SfotConfig;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.tracker.FactoryTrackerAlg;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.RectangleRotate_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.ScaleTranslateRotate2D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.ImagePyramid;
import georegression.geometry.UtilPoint2D_F32;
import java.lang.reflect.Array;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.struct.DogArray;

public class SparseFlowObjectTracker<Image extends ImageGray<Image>, Derivative extends ImageGray<Derivative>> {
    private ImagePyramid<Image> currentImage;
    private Derivative[] currentDerivX;
    private Derivative[] currentDerivY;
    private ImagePyramid<Image> previousImage;
    private Derivative[] previousDerivX;
    private Derivative[] previousDerivY;
    private final PyramidKltTracker<Image, Derivative> klt;
    private PyramidKltFeature track;
    private final DogArray<AssociatedPair> pairs = new DogArray<AssociatedPair>(AssociatedPair::new);
    private final LeastMedianOfSquares<ScaleTranslateRotate2D, AssociatedPair> estimateMotion;
    private boolean trackLost;
    private final SfotConfig config;
    private final ImageGradient<Image, Derivative> gradient;
    private final Class<Image> imageType;
    private final Class<Derivative> derivType;
    private final float maximumErrorFB;
    RectangleRotate_F64 region = new RectangleRotate_F64();

    public SparseFlowObjectTracker(SfotConfig config, Class<Image> imageType, Class<Derivative> derivType, ImageGradient<Image, Derivative> gradient) {
        this.config = config;
        this.imageType = imageType;
        this.derivType = derivType;
        this.gradient = gradient;
        this.maximumErrorFB = (float)(config.maximumErrorFB * config.maximumErrorFB);
        this.klt = FactoryTrackerAlg.kltPyramid(config.trackerConfig, imageType, derivType);
        ModelManagerScaleTranslateRotate2D manager = new ModelManagerScaleTranslateRotate2D();
        this.estimateMotion = new LeastMedianOfSquares<ScaleTranslateRotate2D, AssociatedPair>(config.randSeed, config.robustCycles, Double.MAX_VALUE, 0.0, manager, AssociatedPair.class);
        this.estimateMotion.setModel(GenerateScaleTranslateRotate2D::new, DistanceScaleTranslateRotate2DSq::new);
    }

    public void init(Image input, RectangleRotate_F64 region) {
        if (this.currentImage == null || this.currentImage.getInputWidth() != ((ImageGray)input).width || this.currentImage.getInputHeight() != ((ImageGray)input).height) {
            this.declarePyramid(((ImageGray)input).width, ((ImageGray)input).height);
        }
        this.previousImage.process(input);
        for (int i = 0; i < this.previousImage.getNumLayers(); ++i) {
            ImageGray layer = (ImageGray)this.previousImage.getLayer(i);
            this.gradient.process(layer, this.previousDerivX[i], this.previousDerivY[i]);
        }
        this.trackLost = false;
        this.region.set(region);
    }

    public boolean update(Image input, RectangleRotate_F64 output) {
        if (this.trackLost) {
            return false;
        }
        this.trackFeatures(input, this.region);
        if (this.pairs.size() < this.config.numberOfSamples) {
            System.out.println("Lack of sample pairs");
            this.trackLost = true;
            return false;
        }
        if (!this.estimateMotion.process(this.pairs.toList())) {
            System.out.println("estimate motion failed");
            this.trackLost = true;
            return false;
        }
        if (this.estimateMotion.getFitQuality() > this.config.robustMaxError) {
            System.out.println("exceeded Max estimation error");
            this.trackLost = true;
            return false;
        }
        ScaleTranslateRotate2D model = this.estimateMotion.getModelParameters();
        this.region.width *= model.scale;
        this.region.height *= model.scale;
        double c = Math.cos(model.theta);
        double s = Math.sin(model.theta);
        double x = this.region.cx;
        double y = this.region.cy;
        this.region.cx = (x * c - y * s) * model.scale + model.transX;
        this.region.cy = (x * s + y * c) * model.scale + model.transY;
        this.region.theta += model.theta;
        output.set(this.region);
        this.swapImages();
        return true;
    }

    private void trackFeatures(Image input, RectangleRotate_F64 region) {
        this.pairs.reset();
        this.currentImage.process(input);
        for (int i = 0; i < this.currentImage.getNumLayers(); ++i) {
            ImageGray layer = (ImageGray)this.currentImage.getLayer(i);
            this.gradient.process(layer, this.currentDerivX[i], this.currentDerivY[i]);
        }
        float cx = (float)region.cx;
        float cy = (float)region.cy;
        float height = (float)region.height;
        float width = (float)region.width;
        float c = (float)Math.cos(region.theta);
        float s = (float)Math.sin(region.theta);
        float p = 1.0f / (float)(this.config.numberOfSamples - 1);
        for (int i = 0; i < this.config.numberOfSamples; ++i) {
            float y = (p * (float)i - 0.5f) * height;
            for (int j = 0; j < this.config.numberOfSamples; ++j) {
                float error;
                float x = (p * (float)j - 0.5f) * width;
                float xx = cx + x * c - y * s;
                float yy = cy + x * s + y * c;
                this.track.x = xx;
                this.track.y = yy;
                this.klt.setImage(this.previousImage, (ImageGray[])this.previousDerivX, (ImageGray[])this.previousDerivY);
                if (!this.klt.setDescription(this.track)) continue;
                this.klt.setImage(this.currentImage, (ImageGray[])this.currentDerivX, (ImageGray[])this.currentDerivY);
                KltTrackFault fault = this.klt.track(this.track);
                if (fault != KltTrackFault.SUCCESS) continue;
                float xc = this.track.x;
                float yc = this.track.y;
                if (!this.klt.setDescription(this.track)) continue;
                this.klt.setImage(this.previousImage, (ImageGray[])this.previousDerivX, (ImageGray[])this.previousDerivY);
                fault = this.klt.track(this.track);
                if (fault != KltTrackFault.SUCCESS || (error = UtilPoint2D_F32.distanceSq(this.track.x, this.track.y, xx, yy)) > this.maximumErrorFB) continue;
                AssociatedPair a = this.pairs.grow();
                a.p1.x = xx;
                a.p1.y = yy;
                a.p2.x = xc;
                a.p2.y = yc;
            }
        }
    }

    private void declarePyramid(int imageWidth, int imageHeight) {
        int minSize = (this.config.trackerFeatureRadius * 2 + 1) * 5;
        ConfigDiscreteLevels configLevels = ConfigDiscreteLevels.minSize(minSize);
        this.currentImage = FactoryPyramid.discreteGaussian(configLevels, -1.0, 1, false, ImageType.single(this.imageType));
        this.currentImage.initialize(imageWidth, imageHeight);
        this.previousImage = FactoryPyramid.discreteGaussian(configLevels, -1.0, 1, false, ImageType.single(this.imageType));
        this.previousImage.initialize(imageWidth, imageHeight);
        int numPyramidLayers = this.currentImage.getNumLayers();
        this.previousDerivX = (ImageGray[])Array.newInstance(this.derivType, numPyramidLayers);
        this.previousDerivY = (ImageGray[])Array.newInstance(this.derivType, numPyramidLayers);
        this.currentDerivX = (ImageGray[])Array.newInstance(this.derivType, numPyramidLayers);
        this.currentDerivY = (ImageGray[])Array.newInstance(this.derivType, numPyramidLayers);
        for (int i = 0; i < numPyramidLayers; ++i) {
            int w = this.currentImage.getWidth(i);
            int h = this.currentImage.getHeight(i);
            this.previousDerivX[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.previousDerivY[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.currentDerivX[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.currentDerivY[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
        }
        this.track = new PyramidKltFeature(numPyramidLayers, this.config.trackerFeatureRadius);
    }

    private void swapImages() {
        ImagePyramid<Image> tempP = this.currentImage;
        this.currentImage = this.previousImage;
        this.previousImage = tempP;
        Derivative[] tempD = this.previousDerivX;
        this.previousDerivX = this.currentDerivX;
        this.currentDerivX = tempD;
        tempD = this.previousDerivY;
        this.previousDerivY = this.currentDerivY;
        this.currentDerivY = tempD;
    }

    public boolean isTrackLost() {
        return this.trackLost;
    }

    public SfotConfig getConfig() {
        return this.config;
    }
}

