/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.klt;

import boofcv.alg.tracker.klt.ConfigKlt;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.pyramid.ConfigDiscreteLevels;

public class ConfigPKlt
implements Configuration {
    public ConfigKlt config = new ConfigKlt();
    public double toleranceFB = -1.0;
    public int templateRadius = 2;
    public ConfigDiscreteLevels pyramidLevels = ConfigDiscreteLevels.minSize(40);
    public boolean pruneClose = false;
    public ConfigLength maximumTracks = ConfigLength.relative(0.002, 50.0);

    public ConfigPKlt() {
    }

    public ConfigPKlt(int templateRadius) {
        this.templateRadius = templateRadius;
    }

    public static ConfigPKlt levels(int levels) {
        ConfigPKlt config = new ConfigPKlt();
        config.pyramidLevels = ConfigDiscreteLevels.levels(levels);
        return config;
    }

    @Override
    public void checkValidity() {
        this.config.checkValidity();
        this.pyramidLevels.checkValidity();
        this.maximumTracks.checkValidity();
        BoofMiscOps.checkTrue(this.templateRadius >= 0);
    }

    public void setTo(ConfigPKlt src) {
        this.config.setTo(src.config);
        this.toleranceFB = src.toleranceFB;
        this.templateRadius = src.templateRadius;
        this.pyramidLevels.setTo(src.pyramidLevels);
        this.pruneClose = src.pruneClose;
        this.maximumTracks.setTo(src.maximumTracks);
    }

    public ConfigPKlt copy() {
        ConfigPKlt ret = new ConfigPKlt();
        ret.setTo(this);
        return ret;
    }
}

