/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker;

import boofcv.abst.tracker.PointTrack;
import boofcv.misc.BoofMiscOps;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class PruneCloseTracks<T> {
    private int radius;
    private int gridWidth;
    private int gridHeight;
    private List<TrackDrop<T>>[] gridToCell = new List[0];
    DogArray<List<TrackDrop<T>>> storageLists = new DogArray<List>(ArrayList::new, List::clear);
    DogArray<TrackDrop<T>> storageDrops = new DogArray<TrackDrop>(TrackDrop::new, TrackDrop::reset);
    private TrackInfo<T> trackInfo;
    Comparator<T> ambiguityResolver = (a, b) -> Long.compare(this.trackInfo.getID(b), this.trackInfo.getID(a));
    private final Point2D_F64 candidatePt = new Point2D_F64();
    private final Point2D_F64 currentPt = new Point2D_F64();

    public PruneCloseTracks(int radius, TrackInfo<T> trackInfo) {
        this.radius = radius;
        this.trackInfo = trackInfo;
    }

    public void init(int imgWidth, int imgHeight) {
        this.gridWidth = imgWidth / this.radius + 1;
        this.gridHeight = imgHeight / this.radius + 1;
        int N = this.gridWidth * this.gridHeight;
        if (this.gridToCell.length < N) {
            this.gridToCell = new List[N];
        }
    }

    public void process(List<T> tracks, List<T> dropTracks) {
        int w = this.gridWidth;
        int h = this.gridHeight;
        dropTracks.clear();
        this.storageDrops.reset();
        this.storageLists.reset();
        Arrays.fill(this.gridToCell, 0, w * h, null);
        for (int i = 0; i < tracks.size(); ++i) {
            List<TrackDrop<T>> cell;
            T candidate = tracks.get(i);
            this.trackInfo.getLocation(candidate, this.candidatePt);
            long candidateID = this.trackInfo.getID(candidate);
            int cx = (int)(this.candidatePt.x / (double)this.radius);
            int cy = (int)(this.candidatePt.y / (double)this.radius);
            int x0 = cx - 1;
            int x1 = cx + 2;
            int y0 = cy - 1;
            int y1 = cy + 2;
            if (x0 < 0) {
                x0 = 0;
            }
            if (x1 > w) {
                x1 = w;
            }
            if (y0 < 0) {
                y0 = 0;
            }
            if (y1 > h) {
                y1 = h;
            }
            int centerIndex = cy * w + cx;
            boolean candidateDropped = false;
            for (int y = y0; y < y1; ++y) {
                for (int x = x0; x < x1; ++x) {
                    int index = y * w + x;
                    List<TrackDrop<T>> cell2 = this.gridToCell[index];
                    if (cell2 == null) continue;
                    candidateDropped = this.isCandidateDropped(dropTracks, candidate, candidateID, candidateDropped, cell2);
                }
            }
            if (candidateDropped) {
                dropTracks.add(candidate);
            }
            if ((cell = this.gridToCell[centerIndex]) == null) {
                cell = this.storageLists.grow();
                this.gridToCell[centerIndex] = cell;
                BoofMiscOps.checkTrue(cell.size() == 0);
            }
            TrackDrop<T> td = this.storageDrops.grow();
            td.track = candidate;
            td.dropped = candidateDropped;
            cell.add(td);
        }
    }

    private boolean isCandidateDropped(List<T> dropTracks, T candidate, long candidateID, boolean candidateDropped, List<TrackDrop<T>> cell) {
        for (int trackIdx = 0; trackIdx < cell.size(); ++trackIdx) {
            TrackDrop<T> td = cell.get(trackIdx);
            this.trackInfo.getLocation(td.track, this.currentPt);
            if (Math.abs(this.currentPt.x - this.candidatePt.x) >= (double)this.radius || Math.abs(this.currentPt.y - this.candidatePt.y) >= (double)this.radius) continue;
            int result = this.ambiguityResolver.compare(candidate, td.track);
            if (result < 0) {
                candidateDropped = true;
                continue;
            }
            if (result == 0 && this.trackInfo.getID(td.track) < candidateID) {
                candidateDropped = true;
                continue;
            }
            if (td.dropped) continue;
            dropTracks.add(td.track);
            td.dropped = true;
        }
        return candidateDropped;
    }

    public static PruneCloseTracks<PointTrack> prunePointTrack(int radius) {
        return new PruneCloseTracks<PointTrack>(radius, new TrackInfo<PointTrack>(){

            @Override
            public void getLocation(PointTrack track, Point2D_F64 location) {
                location.setTo(track.pixel);
            }

            @Override
            public long getID(PointTrack track) {
                return track.featureId;
            }
        });
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setAmbiguityResolver(Comparator<T> ambiguityResolver) {
        this.ambiguityResolver = ambiguityResolver;
    }

    public static interface TrackInfo<T> {
        public void getLocation(T var1, Point2D_F64 var2);

        public long getID(T var1);
    }

    protected static class TrackDrop<TD> {
        public TD track;
        public boolean dropped;

        protected TrackDrop() {
        }

        public void reset() {
            this.track = null;
            this.dropped = false;
        }
    }
}

