/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.alg.structure.ScaleSe3_F64;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class ResolveSceneScaleAmbiguity
implements VerbosePrint {
    public double windowFraction = 0.1;
    public TriangulateNViewsMetricH triangulator = FactoryMultiView.triangulateNViewMetricH(null);
    public double infinityTol = 1.0E-12;
    int numFeatures;
    final SceneInfo scene1 = new SceneInfo();
    final SceneInfo scene2 = new SceneInfo();
    Se3_F64 zero_to_world = new Se3_F64();
    Se3_F64 scene1_to_view = new Se3_F64();
    Se3_F64 view_to_scene2 = new Se3_F64();
    Point2D_F64 pixel = new Point2D_F64();
    DogArray<Point2D_F64> workNormalized = new DogArray<Point2D_F64>(Point2D_F64::new);
    DogArray_F64 scales = new DogArray_F64();
    PrintStream verbose;

    public void initialize(int numFeatures) {
        this.numFeatures = numFeatures;
        this.scene1.reset();
        this.scene2.reset();
    }

    public void setScene1(FeatureObservations features, List<Se3_F64> listWorldToView, List<Point2Transform2_F64> intrinsics) {
        this.scene1.features = features;
        this.scene1.listWorldToView = listWorldToView;
        this.scene1.intrinsics = intrinsics;
    }

    public void setScene2(FeatureObservations features, List<Se3_F64> listWorldToView, List<Point2Transform2_F64> intrinsics) {
        this.scene2.features = features;
        this.scene2.listWorldToView = listWorldToView;
        this.scene2.intrinsics = intrinsics;
    }

    public boolean process(ScaleSe3_F64 scene1_to_scene2) {
        scene1_to_scene2.scale = Double.NaN;
        BoofMiscOps.checkTrue(this.scene1.isInitialized(), "Must specify scene1");
        BoofMiscOps.checkTrue(this.scene2.isInitialized(), "Must specify scene2");
        if (this.numFeatures <= 0) {
            return false;
        }
        this.sanityCheckCommonObservations(0);
        this.sanityCheckCommonObservations(this.numFeatures / 2);
        this.workNormalized.resetResize(this.numFeatures);
        this.scales.reset();
        this.scales.reserve(this.numFeatures);
        if (this.verbose != null) {
            this.printSceneInfo(this.scene1);
            this.printSceneInfo(this.scene2);
        }
        this.computeLocalTransforms(Objects.requireNonNull(this.scene1.listWorldToView), this.scene1.listZeroToView);
        this.computeLocalTransforms(Objects.requireNonNull(this.scene2.listWorldToView), this.scene2.listZeroToView);
        int failedTriangulate = 0;
        int failedInfinity = 0;
        int failedBehind1 = 0;
        int failedBehind2 = 0;
        for (int featureIdx = 0; featureIdx < this.numFeatures; ++featureIdx) {
            if (!this.triangulate(this.scene1, featureIdx) || !this.triangulate(this.scene2, featureIdx)) {
                ++failedTriangulate;
                continue;
            }
            this.scene1.location.normalize();
            this.scene2.location.normalize();
            if (Math.abs(this.scene1.location.w) <= this.infinityTol || Math.abs(this.scene2.location.w) <= this.infinityTol) {
                ++failedInfinity;
                continue;
            }
            double z1 = this.scene1.location.z / this.scene1.location.w;
            double z2 = this.scene2.location.z / this.scene2.location.w;
            if (z1 <= 0.0) {
                ++failedBehind1;
                continue;
            }
            if (z2 <= 0.0) {
                ++failedBehind2;
                continue;
            }
            this.scales.add(z2 / z1);
        }
        boolean success = this.selectBestScale(scene1_to_scene2);
        if (this.verbose != null) {
            this.verbose.println("scales.size=" + this.scales.size + "/" + this.numFeatures + " depth_check: tri=" + failedTriangulate + " inf=" + failedInfinity + " behind1=" + failedBehind1 + " behind2=" + failedBehind2 + ", success=" + success + " scale=" + scene1_to_scene2.scale);
        }
        return success;
    }

    void printSceneInfo(SceneInfo scene) {
        List<Se3_F64> listWorldToView = Objects.requireNonNull(scene.listWorldToView);
        this.verbose.print("Global Transforms: { ");
        for (int i = 0; i < listWorldToView.size(); ++i) {
            Se3_F64 s = listWorldToView.get(i);
            this.verbose.printf("(%5.2f %5.2f %5.2f) ", s.T.x, s.T.y, s.T.z);
        }
        this.verbose.println("}");
    }

    private boolean selectBestScale(ScaleSe3_F64 scene1_to_scene2) {
        if (this.scales.size == 0) {
            if (this.verbose != null) {
                this.verbose.println("failed to select scale since scale.size=0");
            }
            return false;
        }
        scene1_to_scene2.scale = this.scales.size == 1 ? this.scales.get(0) : this.selectScaleMinimumLocalVariance();
        this.scene1_to_view.setTo(Objects.requireNonNull(this.scene1.listWorldToView).get(0));
        this.scene1_to_view.T.scale(scene1_to_scene2.scale);
        Objects.requireNonNull(this.scene2.listWorldToView).get(0).invert(this.view_to_scene2);
        this.scene1_to_view.concat(this.view_to_scene2, scene1_to_scene2.transform);
        return true;
    }

    private void sanityCheckCommonObservations(int featureIdx) {
        Objects.requireNonNull(this.scene1.features);
        Objects.requireNonNull(this.scene2.features);
        this.scene1.features.getPixel(0, featureIdx, this.pixel);
        double x = this.pixel.x;
        double y = this.pixel.y;
        this.scene2.features.getPixel(0, featureIdx, this.pixel);
        BoofMiscOps.checkTrue(x == this.pixel.x);
        BoofMiscOps.checkTrue(y == this.pixel.y);
    }

    double selectScaleMinimumLocalVariance() {
        this.scales.sort();
        int window = Math.max(1, (int)((double)this.scales.size * this.windowFraction));
        double bestValue = this.scales.get((window += window % 2 == 0 ? 1 : 0) / 2);
        double bestRange = this.scales.get(window - 1) - this.scales.get(0);
        for (int i = window; i < this.scales.size; ++i) {
            double range = this.scales.get(i) - this.scales.get(i - window + 1);
            if (!(range < bestRange)) continue;
            bestRange = range;
            bestValue = this.scales.get(i - window / 2);
        }
        return bestValue;
    }

    void computeLocalTransforms(List<Se3_F64> listWorldToView, DogArray<Se3_F64> listZeroToView) {
        listWorldToView.get(0).invert(this.zero_to_world);
        listZeroToView.reset();
        listZeroToView.grow().reset();
        for (int view = 1; view < listWorldToView.size(); ++view) {
            this.zero_to_world.concat(listWorldToView.get(view), listZeroToView.grow());
        }
        if (this.verbose != null) {
            this.verbose.print("Local Transforms: { ");
            for (int i = 0; i < listZeroToView.size(); ++i) {
                Se3_F64 s = (Se3_F64)listZeroToView.get(i);
                this.verbose.printf("(%5.2f %5.2f %5.2f) ", s.T.x, s.T.y, s.T.z);
            }
            this.verbose.println("}");
        }
    }

    boolean triangulate(SceneInfo scene, int featureIdx) {
        Objects.requireNonNull(scene.features);
        Objects.requireNonNull(scene.intrinsics);
        this.workNormalized.reset();
        for (int view = 0; view < scene.listZeroToView.size(); ++view) {
            scene.features.getPixel(view, featureIdx, this.pixel);
            scene.intrinsics.get(view).compute(this.pixel.x, this.pixel.y, this.workNormalized.grow());
        }
        return this.triangulator.triangulate(this.workNormalized.toList(), scene.listZeroToView.toList(), scene.location);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    static class SceneInfo {
        @Nullable
        FeatureObservations features;
        @Nullable
        List<Se3_F64> listWorldToView;
        @Nullable
        List<Point2Transform2_F64> intrinsics;
        final DogArray<Se3_F64> listZeroToView = new DogArray<Se3_F64>(Se3_F64::new);
        final Point4D_F64 location = new Point4D_F64();

        SceneInfo() {
        }

        public boolean isInitialized() {
            return this.features != null && this.listWorldToView != null && this.intrinsics != null;
        }

        public void reset() {
            this.features = null;
            this.listWorldToView = null;
            this.intrinsics = null;
            this.listZeroToView.reset();
            this.location.setTo(0.0, 0.0, 0.0, 0.0);
        }
    }

    @FunctionalInterface
    public static interface FeatureObservations {
        public void getPixel(int var1, int var2, Point2D_F64 var3);
    }
}

