/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.similar;

import boofcv.abst.tracker.PointTrack;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.feature.AssociatedIndex;
import georegression.struct.point.Point2D_F64;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.jetbrains.annotations.Nullable;

public class SimilarImagesFromTracks<Track>
implements LookUpSimilarImages {
    public int searchRadius = 5;
    public final ConfigLength minimumCommonTracks = ConfigLength.relative(0.01, 0.0);
    public final DogArray<Frame> frames = new DogArray<Frame>(Frame::new, Frame::reset);
    public final Map<String, Frame> frameMap = new HashMap<String, Frame>();
    public final DogArray<Match> connections = new DogArray<Match>(Match::new, Match::reset);
    String recentQueryID;
    TrackToID<Track> lookupID;
    TrackToPixel<Track> lookupPixel;
    public int imageWidth;
    public int imageHeight;
    Point2D_F64 pixel = new Point2D_F64();
    protected List<PointTrack> tracks = new ArrayList<PointTrack>();
    protected DogArray<AssociatedIndex> pairs = new DogArray<AssociatedIndex>(AssociatedIndex::new);

    public SimilarImagesFromTracks(TrackToID<Track> lookupID, TrackToPixel<Track> lookupPixel) {
        this.lookupID = lookupID;
        this.lookupPixel = lookupPixel;
    }

    public void initialize(int width, int height) {
        this.imageWidth = width;
        this.imageHeight = height;
        this.frames.reset();
        this.frameMap.clear();
        this.connections.reset();
    }

    public void processFrame(List<Track> tracks, long frameID) {
        BoofMiscOps.checkTrue(this.imageWidth != 0, "Must call initialize first and specify the image size");
        Frame current = this.createFrameSaveObservations(tracks, frameID);
        this.findRelatedPastFrames(current);
    }

    protected Frame createFrameSaveObservations(List<Track> tracks, long frameID) {
        Frame current = this.frames.grow();
        current.frameID = frameID + "";
        current.initActive(tracks.size());
        int index = 0;
        for (int trackCnt = 0; trackCnt < tracks.size(); ++trackCnt) {
            Track t = tracks.get(trackCnt);
            this.lookupPixel.getPixel(t, this.pixel);
            current.observations[index++] = (float)this.pixel.x;
            current.observations[index++] = (float)this.pixel.y;
            current.ids[trackCnt] = this.lookupID.getId(t);
            current.id_to_index.put(this.lookupID.getId(t), trackCnt);
        }
        this.frameMap.put(current.frameID, current);
        return current;
    }

    void findRelatedPastFrames(Frame current) {
        int currentTrackCount = ((Frame)this.frames.getTail()).featureCount();
        int oldestFrameConsidered = this.searchRadius < 0 ? 0 : Math.max(0, this.frames.size - 1 - this.searchRadius);
        for (int frameCnt = this.frames.size - 2; frameCnt >= oldestFrameConsidered; --frameCnt) {
            Frame previous = (Frame)this.frames.get(frameCnt);
            this.pairs.reset();
            int prevNumObs = previous.featureCount();
            for (int previousIdx = 0; previousIdx < prevNumObs; ++previousIdx) {
                int currentIdx = current.id_to_index.get(previous.getID(previousIdx));
                if (currentIdx < 0) continue;
                this.pairs.grow().setTo(currentIdx, previousIdx);
            }
            if (this.pairs.size == 0 || this.pairs.size < this.minimumCommonTracks.computeI(Math.min(currentTrackCount, previous.featureCount()))) break;
            this.connectFrames(current, previous, this.pairs);
        }
    }

    protected void connectFrames(Frame current, Frame previous, FastAccess<AssociatedIndex> associated) {
        Match m = this.connections.grow();
        m.init(associated.size);
        m.frameSrc = current;
        m.frameDst = previous;
        for (int assocIdx = 0; assocIdx < associated.size; ++assocIdx) {
            AssociatedIndex a = associated.get(assocIdx);
            m.src[assocIdx] = a.src;
            m.dst[assocIdx] = a.dst;
        }
        m.frameSrc.matches.add(m);
        m.frameDst.matches.add(m);
        previous.related.add(current);
        current.related.add(previous);
    }

    @Override
    public List<String> getImageIDs() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.frames.size; ++i) {
            list.add(((Frame)this.frames.get((int)i)).frameID);
        }
        return list;
    }

    @Override
    public void findSimilar(String target, @Nullable BoofLambdas.Filter<String> filter, List<String> similarImages) {
        similarImages.clear();
        Frame f = this.frameMap.get(target);
        BoofMiscOps.checkTrue(f != null, "Unknown image");
        this.recentQueryID = target;
        for (int i = 0; i < f.related.size(); ++i) {
            if (filter != null && !filter.keep(f.related.get((int)i).frameID)) continue;
            similarImages.add(f.related.get((int)i).frameID);
        }
    }

    @Override
    public void lookupPixelFeats(String target, DogArray<Point2D_F64> features) {
        features.reset();
        Frame f = this.frameMap.get(target);
        if (f == null) {
            throw new IllegalArgumentException("Unknown view=" + target);
        }
        int N = f.featureCount();
        for (int i = 0; i < N; ++i) {
            f.getPixel(i, features.grow());
        }
    }

    @Override
    public boolean lookupAssociated(String viewB, DogArray<AssociatedIndex> pairs) {
        pairs.reset();
        Frame src = this.frameMap.get(this.recentQueryID);
        Frame dst = this.frameMap.get(viewB);
        if (src == null || dst == null) {
            throw new IllegalArgumentException("Unknown view: src=" + this.recentQueryID + " dst=" + viewB);
        }
        boolean matched = false;
        for (int i = 0; i < src.related.size(); ++i) {
            if (src.related.get(i) != dst) continue;
            matched = true;
            break;
        }
        if (!matched) {
            return false;
        }
        Match m = null;
        for (int i = 0; i < src.matches.size(); ++i) {
            Match a = src.matches.get(i);
            if (a.frameSrc != dst && a.frameDst != dst) continue;
            m = a;
            break;
        }
        if (m == null) {
            return false;
        }
        boolean swapped = m.frameSrc != src;
        int size = m.size();
        for (int i = 0; i < size; ++i) {
            if (swapped) {
                pairs.grow().setTo(m.dst[i], m.src[i]);
                continue;
            }
            pairs.grow().setTo(m.src[i], m.dst[i]);
        }
        return true;
    }

    public static interface TrackToID<Track> {
        public long getId(Track var1);
    }

    public static interface TrackToPixel<Track> {
        public void getPixel(Track var1, Point2D_F64 var2);
    }

    public static class Frame {
        public String frameID;
        public float[] observations;
        public long[] ids;
        TLongIntMap id_to_index = new TLongIntHashMap(){
            {
                this.no_entry_value = -1;
            }
        };
        public final List<Frame> related = new ArrayList<Frame>();
        public final List<Match> matches = new ArrayList<Match>();

        public void initActive(int totalFeatures) {
            this.observations = new float[totalFeatures * 2];
            this.ids = new long[totalFeatures];
        }

        public int featureCount() {
            return this.ids.length;
        }

        public void getPixel(int index, Point2D_F64 out) {
            out.x = this.observations[index *= 2];
            out.y = this.observations[index + 1];
        }

        public long getID(int index) {
            return this.ids[index];
        }

        public boolean isMatched(Frame frame) {
            for (int i = 0; i < this.matches.size(); ++i) {
                Match m = this.matches.get(i);
                if (m.frameSrc != frame && m.frameDst != frame) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            this.observations = null;
            this.ids = null;
            this.frameID = null;
            this.id_to_index.clear();
            this.related.clear();
            this.matches.clear();
        }
    }

    public static class Match {
        public int[] src;
        public int[] dst;
        public Frame frameSrc;
        public Frame frameDst;

        public void init(int total) {
            this.src = new int[total];
            this.dst = new int[total];
        }

        public int size() {
            return this.src.length;
        }

        public void reset() {
            this.src = null;
            this.dst = null;
            this.frameSrc = null;
            this.frameDst = null;
        }
    }
}

