/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3.structure;

import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.tracker.PointTrack;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.sfm.d3.structure.SelectTracksInFrameForBundleAdjustment;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.set.hash.TLongHashSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.Factory;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class VisOdomBundleAdjustment<T extends BTrack> {
    public final DogArray<T> tracks;
    public final DogArray<BFrame> frames = new DogArray<BFrame>(BFrame::new, BFrame::reset);
    public final DogArray<BCamera> cameras = new DogArray<BCamera>(BCamera::new, BCamera::reset);
    public final MetricBundleAdjustmentUtils bundle = new MetricBundleAdjustmentUtils();
    public List<BTrack> selectedTracks = new ArrayList<BTrack>();
    SelectTracksInFrameForBundleAdjustment selectTracks = new SelectTracksInFrameForBundleAdjustment(48879L);
    final Se3_F64 world_to_view = new Se3_F64();

    public VisOdomBundleAdjustment(Factory<T> factoryTracks) {
        this.tracks = new DogArray<BTrack>(factoryTracks, BTrack::reset);
        this.bundle.configConverge.setTo(new ConfigConverge(0.001, 0.001, 3));
    }

    public void optimize(@Nullable PrintStream verbose) {
        this.selectTracks.selectTracks(this, this.selectedTracks);
        this.setupBundleStructure();
        this.bundle.setVerbose(verbose, null);
        if (!this.bundle.process() && verbose != null) {
            verbose.println("Bundle adjustment failed!");
        }
        this.copyResults();
    }

    public boolean isOptimizeActive() {
        return this.bundle.configConverge.maxIterations > 0;
    }

    public BCamera addCamera(CameraPinholeBrown camera) {
        BCamera output = this.cameras.grow();
        output.index = this.cameras.size - 1;
        output.original = camera;
        BundleAdjustmentOps.convert(camera, output.bundleCamera);
        return output;
    }

    private void setupBundleStructure() {
        int totalBundleTracks = this.selectedTracks.size();
        SceneStructureMetric structure = this.bundle.getStructure();
        SceneObservations observations = this.bundle.getObservations();
        observations.initialize(this.frames.size);
        structure.initialize(this.cameras.size, this.frames.size, totalBundleTracks);
        for (int cameraIdx = 0; cameraIdx < this.cameras.size; ++cameraIdx) {
            structure.setCamera(cameraIdx, true, ((BCamera)this.cameras.get((int)cameraIdx)).bundleCamera);
        }
        for (int frameIdx = 0; frameIdx < this.frames.size; ++frameIdx) {
            BFrame bf = (BFrame)this.frames.get(frameIdx);
            bf.frame_to_world.invert(this.world_to_view);
            structure.setView(frameIdx, bf.camera.index, frameIdx == 0, this.world_to_view);
            ((BFrame)this.frames.get((int)frameIdx)).listIndex = frameIdx;
        }
        int featureBundleIdx = 0;
        for (int trackIdx = 0; trackIdx < this.tracks.size; ++trackIdx) {
            BTrack bt = (BTrack)this.tracks.get(trackIdx);
            if (!bt.selected) continue;
            Point4D_F64 p = bt.worldLoc;
            structure.setPoint(featureBundleIdx, p.x, p.y, p.z, p.w);
            for (int obsIdx = 0; obsIdx < bt.observations.size; ++obsIdx) {
                BObservation o = (BObservation)bt.observations.get(obsIdx);
                SceneObservations.View view = observations.getView(o.frame.listIndex);
                view.add(featureBundleIdx, (float)o.pixel.x, (float)o.pixel.y);
            }
            ++featureBundleIdx;
        }
        if (featureBundleIdx != structure.points.size) {
            throw new RuntimeException("BUG! tracks feed in and points don't match");
        }
    }

    private void copyResults() {
        SceneStructureMetric structure = this.bundle.getStructure();
        for (int frameIdx = 1; frameIdx < this.frames.size; ++frameIdx) {
            BFrame bf = (BFrame)this.frames.get(frameIdx);
            structure.getParentToView(frameIdx).invert(bf.frame_to_world);
        }
        int featureIdx = 0;
        for (int trackIdx = 0; trackIdx < this.tracks.size; ++trackIdx) {
            BTrack bt = (BTrack)this.tracks.get(trackIdx);
            if (!bt.selected) continue;
            SceneStructureCommon.Point sp = (SceneStructureCommon.Point)structure.points.get(featureIdx);
            sp.get(bt.worldLoc);
            ++featureIdx;
        }
    }

    public void reset() {
        this.frames.reset();
        this.tracks.reset();
        this.cameras.reset();
    }

    public void addObservation(BFrame frame, T track, double pixelX, double pixelY) {
        BObservation o = ((BTrack)track).observations.grow();
        o.frame = frame;
        o.pixel.setTo(pixelX, pixelY);
        frame.tracks.add((BTrack)track);
    }

    public T findByTrackerTrack(PointTrack target) {
        for (int i = 0; i < this.tracks.size; ++i) {
            if (((BTrack)this.tracks.get((int)i)).visualTrack != target) continue;
            return (T)((BTrack)this.tracks.get(i));
        }
        return null;
    }

    public T addTrack(double x, double y, double z, double w) {
        BTrack track = (BTrack)this.tracks.grow();
        track.worldLoc.setTo(x, y, z, w);
        return (T)track;
    }

    public BFrame addFrame(long id) {
        if (this.cameras.size != 1) {
            throw new IllegalArgumentException("To use this function there must be one and only one camera");
        }
        return this.addFrame(0, id);
    }

    public BFrame addFrame(int cameraIndex, long id) {
        BFrame frame = this.frames.grow();
        frame.camera = (BCamera)this.cameras.get(cameraIndex);
        frame.id = id;
        return frame;
    }

    BFrame addFrameDebug(long id) {
        BFrame frame = this.frames.grow();
        frame.id = id;
        return frame;
    }

    public void removeFrame(BFrame frame, List<PointTrack> removedVisualTracks) {
        removedVisualTracks.clear();
        int index = this.frames.indexOf(frame);
        if (index < 0) {
            throw new RuntimeException("BUG! frame not in frames list");
        }
        boolean pruneObservations = false;
        for (int trackIdx = 0; trackIdx < frame.tracks.size; ++trackIdx) {
            BTrack bt = (BTrack)frame.tracks.get(trackIdx);
            if (!bt.removeRef(frame)) {
                throw new RuntimeException("Bug: Track not in frame. frame.id " + frame.id + " track.id " + bt.id);
            }
            if (bt.observations.size() != 0) continue;
            pruneObservations = true;
        }
        if (pruneObservations) {
            for (int i = this.tracks.size - 1; i >= 0; --i) {
                if (((BTrack)this.tracks.get((int)i)).observations.size != 0) continue;
                BTrack t = (BTrack)this.tracks.removeSwap(i);
                if (t.visualTrack == null) continue;
                removedVisualTracks.add(t.visualTrack);
                if (t.visualTrack.cookie != t) {
                    System.out.println("BUG! bt=" + t.id + " tt=" + t.visualTrack.featureId);
                    throw new RuntimeException("BUG!");
                }
                t.visualTrack = null;
            }
        }
        this.frames.remove(index);
    }

    public BFrame getLastFrame() {
        return (BFrame)this.frames.get(this.frames.size - 1);
    }

    public BFrame getFirstFrame() {
        return (BFrame)this.frames.get(0);
    }

    public BCamera getCamera(int index) {
        return (BCamera)this.cameras.get(index);
    }

    public void sanityCheck() {
        TLongHashSet trackSet = new TLongHashSet();
        for (int frameIdx = 0; frameIdx < this.frames.size; ++frameIdx) {
            BFrame bf = (BFrame)this.frames.get(frameIdx);
            for (int trackIdx = 0; trackIdx < bf.tracks.size; ++trackIdx) {
                BTrack bt = (BTrack)bf.tracks.get(trackIdx);
                trackSet.add(bt.id);
                if (!bt.isObservedBy(bf)) {
                    throw new RuntimeException("Frame's track list is out of date. frame.id=" + bf.id + " track.id=" + bt.id + " obs.size " + bt.observations.size);
                }
                if (!this.tracks.isUnused(bt)) continue;
                throw new RuntimeException("BUG! Track is in unused list. frame.id=" + bf.id + " track.id=" + bt.id);
            }
        }
    }

    public SelectTracksInFrameForBundleAdjustment getSelectTracks() {
        return this.selectTracks;
    }

    public static class BCamera {
        public int index;
        public CameraPinholeBrown original;
        public BundlePinholeBrown bundleCamera = new BundlePinholeBrown();

        public void reset() {
            this.index = -1;
            this.original = null;
        }
    }

    public static class BFrame {
        public long id;
        public BCamera camera;
        public final FastArray<BTrack> tracks = new FastArray<BTrack>(BTrack.class);
        public final Se3_F64 frame_to_world = new Se3_F64();
        public int listIndex;

        public void reset() {
            this.id = -1L;
            this.listIndex = -1;
            this.tracks.reset();
            this.frame_to_world.reset();
        }
    }

    public static class BTrack {
        public long id;
        public PointTrack visualTrack;
        public final Point4D_F64 worldLoc = new Point4D_F64();
        public final DogArray<BObservation> observations = new DogArray<BObservation>(BObservation::new, BObservation::reset);
        public boolean hasBeenInlier;
        public boolean selected;

        public boolean isObservedBy(BFrame frame) {
            for (int i = 0; i < this.observations.size; ++i) {
                if (((BObservation[])this.observations.data)[i].frame != frame) continue;
                return true;
            }
            return false;
        }

        public BObservation findObservationBy(BFrame frame) {
            for (int i = 0; i < this.observations.size; ++i) {
                if (((BObservation[])this.observations.data)[i].frame != frame) continue;
                return ((BObservation[])this.observations.data)[i];
            }
            return null;
        }

        public void reset() {
            this.worldLoc.setTo(0.0, 0.0, 0.0, 0.0);
            this.observations.reset();
            this.hasBeenInlier = false;
            this.selected = false;
            this.visualTrack = null;
            this.id = -1L;
        }

        public boolean removeRef(BFrame frame) {
            for (int i = this.observations.size - 1; i >= 0; --i) {
                if (((BObservation[])this.observations.data)[i].frame != frame) continue;
                this.observations.removeSwap(i);
                return true;
            }
            return false;
        }
    }

    public static class BObservation {
        public final Point2D_F64 pixel = new Point2D_F64();
        public BFrame frame;

        public void reset() {
            this.pixel.setTo(-1.0, -1.0);
            this.frame = null;
        }
    }
}

