/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.ops.DConvertMatrixStruct;
import org.jetbrains.annotations.Nullable;

public class MultiBaselineDisparityMedian
implements VerbosePrint {
    final CameraPinhole fusedIntrinsic = new CameraPinhole();
    final int fusedDisparityMin = 0;
    final int fusedDisparityRange = 100;
    double fusedBaseline;
    PixelTransform<Point2D_F64> pixelOrig_to_Undist;
    final DogArray<DisparityImage> images = new DogArray<DisparityImage>(DisparityImage::new, DisparityImage::reset);
    final FusedImage fused = new FusedImage();
    private final Homography2D_F64 rect = new Homography2D_F64();
    PrintStream verbose;

    public void initialize(CameraPinhole intrinsic, PixelTransform<Point2D_F64> pixelDist_to_Undist) {
        this.fusedIntrinsic.setTo(intrinsic);
        this.images.reset();
        this.fused.resize(intrinsic.width, intrinsic.height);
        this.pixelOrig_to_Undist = pixelDist_to_Undist;
    }

    public void addDisparity(GrayF32 disparity, GrayU8 mask, DisparityParameters parameters, DMatrixRMaj undist_to_rect_px) {
        InputSanityCheck.checkSameShape(disparity, mask);
        parameters.checkValidity();
        DisparityImage d = this.images.grow();
        d.disparity.setTo(disparity);
        d.mask.setTo(mask);
        d.undist_to_rect_px.setTo(undist_to_rect_px);
        d.parameters.setTo(parameters);
    }

    public boolean process(GrayF32 disparity) {
        int i;
        BoofMiscOps.checkTrue(!this.images.isEmpty(), "No images have been added");
        disparity.reshape(this.fused.width, this.fused.height);
        this.fusedBaseline = 0.0;
        for (i = 0; i < this.images.size; ++i) {
            this.fusedBaseline = Math.max(this.fusedBaseline, ((DisparityImage)this.images.get((int)i)).parameters.baseline);
        }
        for (i = 0; i < this.images.size; ++i) {
            if (this.addToFusedImage((DisparityImage)this.images.get(i))) continue;
            return false;
        }
        if (!this.computeFused(disparity)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Not a single disparity computed in any of the images. images.size=" + this.images.size);
            }
            return false;
        }
        return this.computeDynamicParameters(disparity);
    }

    boolean addToFusedImage(DisparityImage image) {
        GrayF32 disparity = image.disparity;
        GrayU8 mask = image.mask;
        DisparityParameters imageParam = image.parameters;
        float imageRange = imageParam.disparityRange;
        float imageMin = imageParam.disparityMin;
        double imageFocalX = imageParam.pinhole.fx;
        double imageBaseline = imageParam.baseline;
        CameraPinhole imagePinhole = imageParam.pinhole;
        DConvertMatrixStruct.convert(image.undist_to_rect_px, this.rect);
        Point2D_F64 undistPix = new Point2D_F64();
        Point2D_F64 rectPix = new Point2D_F64();
        for (int origPixY = 0; origPixY < this.fused.height; ++origPixY) {
            for (int origPixX = 0; origPixX < this.fused.width; ++origPixX) {
                float imageDisp;
                this.pixelOrig_to_Undist.compute(origPixX, origPixY, undistPix);
                HomographyPointOps_F64.transform(this.rect, undistPix.x, undistPix.y, rectPix);
                if (rectPix.x < 0.0 || rectPix.y < 0.0) continue;
                int rectPixX = (int)(rectPix.x + 0.5);
                int rectPixY = (int)(rectPix.y + 0.5);
                if (rectPixX >= mask.width || rectPixY >= mask.height || mask.unsafe_get(rectPixX, rectPixY) == 0 || (imageDisp = disparity.unsafe_get(rectPixX, rectPixY)) >= imageRange) continue;
                float d = imageDisp + imageMin;
                if (d != 0.0f) {
                    double rectZ = imageBaseline * imageFocalX / (double)d;
                    double rectX = rectZ * ((double)rectPixX - imagePinhole.cx) / imagePinhole.fx;
                    double rectY = rectZ * ((double)rectPixY - imagePinhole.cy) / imagePinhole.fy;
                    double worldZ = this.dotRightCol(imageParam.rotateToRectified, rectX, rectY, rectZ);
                    float fusedDisp = (float)(this.fusedBaseline * this.fusedIntrinsic.fx / worldZ);
                    this.fused.get(origPixX, origPixY).add(fusedDisp);
                    continue;
                }
                this.fused.get(origPixX, origPixY).add(0.0f);
            }
        }
        return true;
    }

    double dotRightCol(DMatrixRMaj R, double x, double y, double z) {
        return R.data[2] * x + R.data[5] * y + R.data[8] * z;
    }

    boolean computeFused(GrayF32 disparity) {
        boolean singleValidPixel = false;
        for (int y = 0; y < this.fused.height; ++y) {
            int indexOut = disparity.startIndex + y * disparity.stride;
            for (int x = 0; x < this.fused.width; ++x) {
                float outputValue;
                DogArray_F32 values = this.fused.get(x, y);
                if (values.size == 0) {
                    outputValue = Float.MAX_VALUE;
                } else if (values.size == 1) {
                    singleValidPixel = true;
                    outputValue = values.data[0];
                } else if (values.size == 2) {
                    singleValidPixel = true;
                    outputValue = 0.5f * (values.data[0] + values.data[1]);
                } else {
                    outputValue = QuickSelect.select(values.data, values.size / 2, values.size);
                    singleValidPixel = true;
                }
                disparity.data[indexOut++] = outputValue;
            }
        }
        return singleValidPixel;
    }

    boolean computeDynamicParameters(GrayF32 disparity) {
        float dispMax = 0.0f;
        for (int y = 0; y < disparity.height; ++y) {
            int index = disparity.startIndex + y * disparity.stride;
            for (int x = 0; x < disparity.width; ++x) {
                float d;
                if ((d = disparity.data[index++]) == Float.MAX_VALUE) continue;
                dispMax = Math.max(dispMax, d);
            }
        }
        if ((double)dispMax <= 0.0) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: all valid points are at infinity");
            }
            return false;
        }
        float scale = (float)((double)(this.fusedDisparityRange - 1) / Math.ceil(dispMax));
        this.fusedBaseline *= (double)scale;
        float fRange = 100.0f;
        for (int y = 0; y < disparity.height; ++y) {
            int index = disparity.startIndex + y * disparity.stride;
            int x = 0;
            while (x < disparity.width) {
                float d = disparity.data[index];
                if (d == Float.MAX_VALUE) {
                    disparity.data[index] = 100.0f;
                } else {
                    disparity.data[index] = disparity.data[index] * scale;
                    if (UtilEjml.isUncountable(disparity.data[index])) {
                        throw new RuntimeException("BUG");
                    }
                }
                ++x;
                ++index;
            }
        }
        return true;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public CameraPinhole getFusedIntrinsic() {
        return this.fusedIntrinsic;
    }

    public int getFusedDisparityMin() {
        return this.fusedDisparityMin;
    }

    public int getFusedDisparityRange() {
        return this.fusedDisparityRange;
    }

    public double getFusedBaseline() {
        return this.fusedBaseline;
    }

    public DogArray<DisparityImage> getImages() {
        return this.images;
    }

    public FusedImage getFused() {
        return this.fused;
    }

    static class FusedImage {
        public final DogArray<DogArray_F32> pixels = new DogArray<DogArray_F32>(DogArray_F32::new, DogArray_F32::reset);
        public int width;
        public int height;

        FusedImage() {
        }

        public DogArray_F32 get(int x, int y) {
            return (DogArray_F32)this.pixels.get(y * this.width + x);
        }

        public void resize(int width, int height) {
            this.pixels.reset();
            this.pixels.resize(width * height);
            this.width = width;
            this.height = height;
        }
    }

    static class DisparityImage {
        public final GrayF32 disparity = new GrayF32(1, 1);
        public final GrayU8 mask = new GrayU8(1, 1);
        public final DMatrixRMaj undist_to_rect_px = new DMatrixRMaj(3, 3);
        public final DisparityParameters parameters = new DisparityParameters();

        DisparityImage() {
        }

        public void reset() {
            this.disparity.reshape(1, 1);
            this.mask.reshape(1, 1);
            CommonOps_DDRM.fill(this.undist_to_rect_px, 0.0);
            this.parameters.reset();
        }
    }
}

