/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.PruneStructureFromSceneProjective;
import boofcv.abst.geo.bundle.ScaleSceneStructure;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.ConfigConverge;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class RefineThreeViewProjectiveGeometric {
    TriangulateNViewsProjective triangulator;
    SceneStructureProjective structure;
    SceneObservations observations;
    DMatrixRMaj P1 = CommonOps_DDRM.identity(3, 4);
    ConfigConverge converge = new ConfigConverge(1.0E-8, 1.0E-8, 200);
    BundleAdjustment<SceneStructureProjective> sba;
    boolean scale = true;
    ScaleSceneStructure scaler = new ScaleSceneStructure();

    public RefineThreeViewProjectiveGeometric() {
        this.triangulator = FactoryMultiView.triangulateNViewProj(ConfigTriangulation.GEOMETRIC());
        ConfigLevenbergMarquardt configLM = new ConfigLevenbergMarquardt();
        configLM.hessianScaling = false;
        ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
        configSBA.configOptimizer = configLM;
        this.sba = FactoryMultiView.bundleSparseProjective(configSBA);
    }

    public RefineThreeViewProjectiveGeometric(TriangulateNViewsProjective triangulator, BundleAdjustment<SceneStructureProjective> sba) {
        this.triangulator = triangulator;
        this.sba = sba;
    }

    public boolean refine(List<AssociatedTriple> listObs, DMatrixRMaj P2, DMatrixRMaj P3) {
        CommonOps_DDRM.setIdentity(this.P1);
        this.initializeStructure(listObs, P2, P3);
        if (this.scale) {
            this.scaler.applyScale(this.structure, this.observations);
        }
        this.sba.setParameters(this.structure, this.observations);
        this.sba.configure(this.converge.ftol, this.converge.gtol, this.converge.maxIterations);
        if (!this.sba.optimize(this.structure)) {
            return false;
        }
        P2.setTo(((SceneStructureProjective.View[])this.structure.views.data)[1].worldToView);
        P3.setTo(((SceneStructureProjective.View[])this.structure.views.data)[2].worldToView);
        if (this.scale) {
            ((NormalizationPoint2D)this.scaler.pixelScaling.get(1)).remove(P2, P2);
            ((NormalizationPoint2D)this.scaler.pixelScaling.get(2)).remove(P3, P3);
        }
        return true;
    }

    private void initializeStructure(List<AssociatedTriple> listObs, DMatrixRMaj P2, DMatrixRMaj P3) {
        ArrayList<DMatrixRMaj> cameraMatrices = new ArrayList<DMatrixRMaj>();
        cameraMatrices.add(this.P1);
        cameraMatrices.add(P2);
        cameraMatrices.add(P3);
        ArrayList<Point2D_F64> triangObs = new ArrayList<Point2D_F64>();
        triangObs.add(null);
        triangObs.add(null);
        triangObs.add(null);
        this.structure = new SceneStructureProjective(true);
        this.structure.initialize(3, listObs.size());
        this.observations = new SceneObservations();
        this.observations.initialize(3);
        this.structure.setView(0, true, this.P1, 0, 0);
        this.structure.setView(1, false, P2, 0, 0);
        this.structure.setView(2, false, P3, 0, 0);
        boolean needsPruning = false;
        Point4D_F64 X2 = new Point4D_F64();
        for (int i = 0; i < listObs.size(); ++i) {
            AssociatedTriple t = listObs.get(i);
            triangObs.set(0, t.p1);
            triangObs.set(1, t.p2);
            triangObs.set(2, t.p3);
            if (this.triangulator.triangulate(triangObs, cameraMatrices, X2)) {
                this.observations.getView(0).add(i, (float)t.p1.x, (float)t.p1.y);
                this.observations.getView(1).add(i, (float)t.p2.x, (float)t.p2.y);
                this.observations.getView(2).add(i, (float)t.p3.x, (float)t.p3.y);
                ((SceneStructureCommon.Point)this.structure.points.get(i)).set(X2.x, X2.y, X2.z, X2.w);
                continue;
            }
            needsPruning = true;
        }
        if (needsPruning) {
            PruneStructureFromSceneProjective pruner = new PruneStructureFromSceneProjective(this.structure, this.observations);
            pruner.prunePoints(1);
        }
    }

    public TriangulateNViewsProjective getTriangulator() {
        return this.triangulator;
    }

    public SceneStructureProjective getStructure() {
        return this.structure;
    }

    public SceneObservations getObservations() {
        return this.observations;
    }

    public BundleAdjustment<SceneStructureProjective> getSba() {
        return this.sba;
    }

    public boolean isScale() {
        return this.scale;
    }

    public void setScale(boolean scale) {
        this.scale = scale;
    }

    public ConfigConverge getConverge() {
        return this.converge;
    }
}

