/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_F64;
import georegression.struct.so.Rodrigues_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.derivative.NumericalJacobianForward_DDRM;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class RefineTwoViewPinholeRotation
implements VerbosePrint {
    public final ConfigConverge converge = new ConfigConverge(1.0E-12, 1.0E-8, 100);
    public UnconstrainedLeastSquares<DMatrixRMaj> minimizer = FactoryOptimization.levenbergMarquardt(null, false);
    boolean assumeSameIntrinsics = false;
    boolean zeroSkew = true;
    boolean assumeUnityAspect = true;
    boolean knownFocalLength = false;
    double errorBefore;
    double errorAfter;
    ResidualFunction function = new ResidualFunction();
    DogArray_F64 initialParameters = new DogArray_F64();
    List<AssociatedPair> associatedPixels;
    PrintStream verbose = null;
    CameraPinhole inputIntrinsic1;
    CameraPinhole inputIntrinsic2;

    public boolean refine(List<AssociatedPair> associatedPixels, DMatrixRMaj rotation, CameraPinhole intrinsic1, CameraPinhole intrinsic2) {
        int iterations;
        this.associatedPixels = associatedPixels;
        this.inputIntrinsic1 = intrinsic1;
        this.inputIntrinsic2 = intrinsic2;
        ConvertRotation3D_F64.matrixToRodrigues(rotation, this.function.state.rotation);
        this.function.state.intrinsic1.setTo(intrinsic1);
        this.function.state.intrinsic2.setTo(intrinsic2);
        this.initialParameters.resize(this.function.getNumOfInputsN());
        this.function.state.encode(this.initialParameters.data);
        this.minimizer.setFunction(this.function, new NumericalJacobianForward_DDRM(new ResidualFunction()));
        this.minimizer.initialize(this.initialParameters.data, this.converge.ftol, this.converge.gtol);
        this.errorBefore = this.minimizer.getFunctionValue();
        for (iterations = 0; iterations < this.converge.maxIterations && !this.minimizer.iterate(); ++iterations) {
        }
        this.errorAfter = this.minimizer.getFunctionValue();
        this.function.state.decode(this.minimizer.getParameters());
        if (this.verbose != null) {
            double theta = UtilAngle.degree(this.function.state.rotation.theta);
            CameraPinhole found1 = this.function.state.intrinsic1;
            CameraPinhole found2 = this.function.state.intrinsic2;
            this.verbose.printf("before=%.2e after=%.2e iterations=%d converged=%s, view1={fx=%.1f fy=%.1f, cx=%.1f cy=%.1f), view2=(fx=%.1f fy=%.1f, cx=%.1f cy=%.1f) theta=%.2f\n", this.errorBefore, this.errorAfter, iterations, this.minimizer.isConverged(), found1.fx, found1.fy, found1.cx, found1.cy, found2.fx, found2.fy, found2.cx, found2.cy, theta);
        }
        intrinsic1.setTo(this.function.state.intrinsic1);
        intrinsic2.setTo(this.function.state.intrinsic2);
        ConvertRotation3D_F64.rodriguesToMatrix(this.function.state.rotation, rotation);
        return true;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public ConfigConverge getConverge() {
        return this.converge;
    }

    public UnconstrainedLeastSquares<DMatrixRMaj> getMinimizer() {
        return this.minimizer;
    }

    public void setMinimizer(UnconstrainedLeastSquares<DMatrixRMaj> minimizer) {
        this.minimizer = minimizer;
    }

    public boolean isAssumeSameIntrinsics() {
        return this.assumeSameIntrinsics;
    }

    public void setAssumeSameIntrinsics(boolean assumeSameIntrinsics) {
        this.assumeSameIntrinsics = assumeSameIntrinsics;
    }

    public boolean isZeroSkew() {
        return this.zeroSkew;
    }

    public void setZeroSkew(boolean zeroSkew) {
        this.zeroSkew = zeroSkew;
    }

    public boolean isAssumeUnityAspect() {
        return this.assumeUnityAspect;
    }

    public void setAssumeUnityAspect(boolean assumeUnityAspect) {
        this.assumeUnityAspect = assumeUnityAspect;
    }

    public boolean isKnownFocalLength() {
        return this.knownFocalLength;
    }

    public void setKnownFocalLength(boolean knownFocalLength) {
        this.knownFocalLength = knownFocalLength;
    }

    public double getErrorBefore() {
        return this.errorBefore;
    }

    public double getErrorAfter() {
        return this.errorAfter;
    }

    class ResidualFunction
    implements FunctionNtoM {
        State state;
        DMatrixRMaj K1_inv;
        DMatrixRMaj K2;
        DMatrixRMaj R;
        DMatrixRMaj H;
        Point2D_F64 predicted2;
        DMatrixRMaj K2R;

        ResidualFunction() {
            this.state = new State();
            this.K1_inv = new DMatrixRMaj(3, 3);
            this.K2 = new DMatrixRMaj(3, 3);
            this.R = new DMatrixRMaj(3, 3);
            this.H = new DMatrixRMaj(3, 3);
            this.predicted2 = new Point2D_F64();
            this.K2R = new DMatrixRMaj(3, 3);
        }

        @Override
        public void process(double[] input, double[] output) {
            this.state.decode(input);
            ConvertRotation3D_F64.rodriguesToMatrix(this.state.rotation, this.R);
            PerspectiveOps.pinholeToMatrix(this.state.intrinsic1, this.K1_inv);
            PerspectiveOps.pinholeToMatrix(this.state.intrinsic2, this.K2);
            PerspectiveOps.invertCalibrationMatrix(this.K1_inv, this.K1_inv);
            CommonOps_DDRM.mult(this.K2, this.R, this.K2R);
            CommonOps_DDRM.mult(this.K2R, this.K1_inv, this.H);
            int errorIndex = 0;
            for (int i = 0; i < RefineTwoViewPinholeRotation.this.associatedPixels.size(); ++i) {
                AssociatedPair pair = RefineTwoViewPinholeRotation.this.associatedPixels.get(i);
                GeometryMath_F64.mult(this.H, pair.p1, this.predicted2);
                output[errorIndex++] = pair.p2.x - this.predicted2.x;
                output[errorIndex++] = pair.p2.y - this.predicted2.y;
            }
        }

        @Override
        public int getNumOfInputsN() {
            int intrinsicUnknown = 2;
            if (!RefineTwoViewPinholeRotation.this.zeroSkew) {
                ++intrinsicUnknown;
            }
            if (!RefineTwoViewPinholeRotation.this.knownFocalLength) {
                ++intrinsicUnknown;
                if (!RefineTwoViewPinholeRotation.this.assumeUnityAspect) {
                    ++intrinsicUnknown;
                }
            }
            if (!RefineTwoViewPinholeRotation.this.assumeSameIntrinsics) {
                intrinsicUnknown *= 2;
            }
            return 4 + intrinsicUnknown;
        }

        @Override
        public int getNumOfOutputsM() {
            return RefineTwoViewPinholeRotation.this.associatedPixels.size() * 2;
        }
    }

    class State {
        public final Rodrigues_F64 rotation = new Rodrigues_F64();
        public final CameraPinhole intrinsic1 = new CameraPinhole();
        public final CameraPinhole intrinsic2 = new CameraPinhole();

        State() {
        }

        public void encode(double[] parameters) {
            int index = 0;
            index = this.encodeIntrinsics(this.intrinsic1, index, parameters);
            if (!RefineTwoViewPinholeRotation.this.assumeSameIntrinsics) {
                index = this.encodeIntrinsics(this.intrinsic2, index, parameters);
            }
            parameters[index++] = this.rotation.unitAxisRotation.x;
            parameters[index++] = this.rotation.unitAxisRotation.y;
            parameters[index++] = this.rotation.unitAxisRotation.z;
            parameters[index] = this.rotation.theta;
        }

        public void decode(double[] parameters) {
            int index = 0;
            index = this.decodeIntrinsics(RefineTwoViewPinholeRotation.this.inputIntrinsic1, parameters, index, this.intrinsic1);
            if (!RefineTwoViewPinholeRotation.this.assumeSameIntrinsics) {
                index = this.decodeIntrinsics(RefineTwoViewPinholeRotation.this.inputIntrinsic2, parameters, index, this.intrinsic2);
            } else {
                this.intrinsic2.setTo(this.intrinsic1);
            }
            this.rotation.unitAxisRotation.x = parameters[index++];
            this.rotation.unitAxisRotation.y = parameters[index++];
            this.rotation.unitAxisRotation.z = parameters[index++];
            this.rotation.theta = parameters[index];
            this.rotation.unitAxisRotation.normalize();
        }

        private int encodeIntrinsics(CameraPinhole intrinsic, int index, double[] parameters) {
            parameters[index++] = intrinsic.cx;
            parameters[index++] = intrinsic.cy;
            if (!RefineTwoViewPinholeRotation.this.knownFocalLength) {
                parameters[index++] = intrinsic.fx;
                if (!RefineTwoViewPinholeRotation.this.assumeUnityAspect) {
                    parameters[index++] = intrinsic.fy;
                }
            }
            if (!RefineTwoViewPinholeRotation.this.zeroSkew) {
                parameters[index++] = intrinsic.skew;
            }
            return index;
        }

        private int decodeIntrinsics(CameraPinhole prior, double[] parameters, int index, CameraPinhole intrinsic) {
            intrinsic.cx = parameters[index++];
            intrinsic.cy = parameters[index++];
            if (!RefineTwoViewPinholeRotation.this.knownFocalLength) {
                intrinsic.fx = parameters[index++];
                intrinsic.fy = !RefineTwoViewPinholeRotation.this.assumeUnityAspect ? parameters[index++] : intrinsic.fx;
            } else {
                intrinsic.fx = prior.fx;
                intrinsic.fy = prior.fy;
            }
            intrinsic.skew = !RefineTwoViewPinholeRotation.this.zeroSkew ? parameters[index++] : 0.0;
            return index;
        }
    }
}

