/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.robust.GenerateAffine2D;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.ScaleTranslateRotate2D;
import georegression.struct.affine.Affine2D_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class GenerateScaleTranslateRotate2D
implements ModelGenerator<ScaleTranslateRotate2D, AssociatedPair> {
    private final Affine2D_F64 affine = new Affine2D_F64();
    private final GenerateAffine2D generateAffine = new GenerateAffine2D();
    private final DMatrixRMaj R = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj U = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj V = new DMatrixRMaj(2, 2);
    private final SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(2, 2, true, true, true);

    @Override
    public boolean generate(List<AssociatedPair> dataSet, ScaleTranslateRotate2D output) {
        if (!this.generateAffine.generate(dataSet, this.affine)) {
            return false;
        }
        this.R.data[0] = this.affine.a11;
        this.R.data[1] = this.affine.a12;
        this.R.data[2] = this.affine.a21;
        this.R.data[3] = this.affine.a22;
        if (!this.svd.decompose(this.R)) {
            return false;
        }
        double[] sv = this.svd.getSingularValues();
        output.scale = (sv[0] + sv[1]) / 2.0;
        if (output.scale < 0.0) {
            throw new RuntimeException("Handle this case");
        }
        this.svd.getU(this.U, false);
        this.svd.getV(this.V, false);
        CommonOps_DDRM.multTransB(this.U, this.V, this.R);
        if (CommonOps_DDRM.det(this.R) < 0.0) {
            for (int i = 0; i < 2; ++i) {
                this.V.set(i, 1, -this.V.get(i, 1));
            }
            CommonOps_DDRM.mult(this.U, this.V, this.R);
        }
        output.theta = Math.atan2(-this.R.data[1], this.R.data[0]);
        output.transX = this.affine.tx;
        output.transY = this.affine.ty;
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

