/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.abst.geo.optimization.ResidualsCodecToMatrix;
import boofcv.alg.geo.pose.PnPRodriguesCodec;
import boofcv.alg.geo.pose.PnPStereoJacobianRodrigues;
import boofcv.alg.geo.pose.PnPStereoResidualReprojection;
import boofcv.alg.geo.pose.RefinePnPStereo;
import boofcv.alg.geo.pose.Se3ToStereoPoseCodec;
import boofcv.struct.sfm.Stereo2D3D;
import boofcv.struct.sfm.StereoPose;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;

public class PnPStereoRefineRodrigues
implements RefinePnPStereo {
    private final ModelCodec<Se3_F64> motionCodec = new PnPRodriguesCodec();
    private final ResidualsCodecToMatrix<StereoPose, Stereo2D3D> func;
    private final PnPStereoJacobianRodrigues jacobian = new PnPStereoJacobianRodrigues();
    private final StereoPose stereoPose = new StereoPose();
    private final double[] param;
    protected UnconstrainedLeastSquares minimizer;
    private final int maxIterations;
    private final double convergenceTol;

    public PnPStereoRefineRodrigues(double convergenceTol, int maxIterations) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.minimizer = FactoryOptimization.levenbergMarquardt(null, false);
        Se3ToStereoPoseCodec paramModel = new Se3ToStereoPoseCodec(this.motionCodec);
        this.func = new ResidualsCodecToMatrix<StereoPose, Stereo2D3D>(paramModel, new PnPStereoResidualReprojection(), this.stereoPose);
        this.param = new double[paramModel.getParamLength()];
    }

    @Override
    public void setLeftToRight(Se3_F64 leftToRight) {
        this.stereoPose.cam0ToCam1 = leftToRight;
        this.jacobian.setLeftToRight(leftToRight);
    }

    @Override
    public boolean fitModel(List<Stereo2D3D> obs, Se3_F64 worldToLeft, Se3_F64 refinedWorldToLeft) {
        this.motionCodec.encode(worldToLeft, this.param);
        this.func.setObservations(obs);
        this.jacobian.setObservations(obs);
        this.minimizer.setFunction(this.func, this.jacobian);
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)obs.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        this.motionCodec.decode(this.minimizer.getParameters(), refinedWorldToLeft);
        return true;
    }

    @Override
    public double getFitScore() {
        return this.minimizer.getFunctionValue();
    }
}

