/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.Point2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;

public class PnPDistanceReprojectionSq
implements DistanceFromModelMultiView<Se3_F64, Point2D3D> {
    private Se3_F64 worldToCamera;
    private Point3D_F64 X = new Point3D_F64();
    private NormalizedToPixelError pixelError = new NormalizedToPixelError(1.0, 1.0, 0.0);

    @Override
    public void setModel(Se3_F64 worldToCamera) {
        this.worldToCamera = worldToCamera;
    }

    @Override
    public double distance(Point2D3D pt) {
        SePointOps_F64.transform(this.worldToCamera, pt.location, this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        Point2D_F64 p = pt.getObservation();
        return this.pixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
    }

    @Override
    public void distances(List<Point2D3D> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.distance(observations.get(i));
        }
    }

    @Override
    public Class<Point2D3D> getPointType() {
        return Point2D3D.class;
    }

    @Override
    public Class<Se3_F64> getModelType() {
        return Se3_F64.class;
    }

    @Override
    public void setIntrinsic(int view, CameraPinhole intrinsic) {
        this.pixelError.setTo(intrinsic.fx, intrinsic.fy, intrinsic.skew);
    }

    @Override
    public int getNumberOfViews() {
        return 1;
    }
}

