/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PairLineNorm;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class HomographyInducedStereoLinePt {
    private DMatrixRMaj F;
    private Point3D_F64 e2 = new Point3D_F64();
    private DMatrixRMaj H = new DMatrixRMaj(3, 3);
    private AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();
    private DMatrixRMaj el = new DMatrixRMaj(3, 3);
    private DMatrixRMaj lf = new DMatrixRMaj(3, 3);
    private Point3D_F64 Fx = new Point3D_F64();
    private Point3D_F64 t0 = new Point3D_F64();
    private Point3D_F64 t1 = new Point3D_F64();

    public void setFundamental(DMatrixRMaj F, Point3D_F64 e2) {
        this.F = F;
        if (e2 != null) {
            this.e2.setTo(e2);
        } else {
            MultiViewOps.extractEpipoles(F, new Point3D_F64(), this.e2);
        }
    }

    public void process(PairLineNorm line, AssociatedPair point) {
        GeometryMath_F64.mult(this.F, point.p1, (GeoTuple3D_F64)this.Fx);
        GeometryMath_F64.cross(this.Fx, (GeoTuple3D_F64)line.getL2(), (GeoTuple3D_F64)this.t0);
        GeometryMath_F64.cross((GeoTuple2D_F64)point.p2, (GeoTuple3D_F64)this.t0, (GeoTuple3D_F64)this.t1);
        GeometryMath_F64.cross((GeoTuple2D_F64)point.p2, (GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.t0);
        double top = GeometryMath_F64.dot(this.t0, this.t1);
        double bottom = this.t0.normSq() * (line.l1.x * point.p1.x + line.l1.y * point.p1.y + line.l1.z);
        GeometryMath_F64.outerProd(this.e2, line.l1, this.el);
        GeometryMath_F64.multCrossA(line.l2, this.F, this.lf);
        CommonOps_DDRM.add(this.lf, top / bottom, this.el, this.H);
        this.adjust.adjust(this.H, point);
    }

    public DMatrixRMaj getHomography() {
        return this.H;
    }
}

