/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.struct.calib.CameraUniversalOmni;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class BundleUniversalOmni
implements BundleAdjustmentCamera {
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;
    public double mirrorOffset;
    public double[] radial;
    public double t1;
    public double t2;
    public boolean zeroSkew;
    public boolean tangential;
    public boolean fixedMirror;
    DMatrix3x3 jacSp = new DMatrix3x3();

    public BundleUniversalOmni(boolean zeroSkew, int numRadial, boolean includeTangential, boolean fixedMirror) {
        this.radial = new double[numRadial];
        this.zeroSkew = zeroSkew;
        this.tangential = includeTangential;
        this.fixedMirror = fixedMirror;
    }

    public BundleUniversalOmni(boolean zeroSkew, int numRadial, boolean includeTangential, double mirrorOffset) {
        this(zeroSkew, numRadial, includeTangential, true);
        this.mirrorOffset = mirrorOffset;
    }

    public BundleUniversalOmni(CameraUniversalOmni intrinsic) {
        this.radial = intrinsic.radial == null ? new double[0] : (double[])intrinsic.radial.clone();
        this.zeroSkew = intrinsic.skew == 0.0;
        this.fx = intrinsic.fx;
        this.fy = intrinsic.fy;
        this.cx = intrinsic.cx;
        this.cy = intrinsic.cy;
        if (intrinsic.t1 != 0.0 || intrinsic.t2 != 0.0) {
            this.t1 = intrinsic.t1;
            this.t2 = intrinsic.t2;
        } else {
            this.tangential = false;
        }
        this.skew = intrinsic.skew;
        this.mirrorOffset = intrinsic.mirrorOffset;
    }

    public void convert(CameraUniversalOmni out) {
        out.fx = this.fx;
        out.fy = this.fy;
        out.cx = this.cx;
        out.cy = this.cy;
        out.skew = this.zeroSkew ? 0.0 : this.skew;
        out.radial = (double[])this.radial.clone();
        if (this.tangential) {
            out.t1 = this.t1;
            out.t2 = this.t2;
        } else {
            out.t2 = 0.0;
            out.t1 = 0.0;
        }
        out.mirrorOffset = this.mirrorOffset;
    }

    public void setK(DMatrixRMaj K) {
        this.fx = K.get(0, 0);
        this.fy = K.get(1, 1);
        this.cx = K.get(0, 2);
        this.cy = K.get(1, 2);
        this.skew = this.zeroSkew ? 0.0 : K.get(0, 1);
    }

    @Override
    public void setIntrinsic(double[] parameters, int offset) {
        this.fx = parameters[offset++];
        this.fy = parameters[offset++];
        this.cx = parameters[offset++];
        this.cy = parameters[offset++];
        for (int i = 0; i < this.radial.length; ++i) {
            this.radial[i] = parameters[offset++];
        }
        if (this.tangential) {
            this.t1 = parameters[offset++];
            this.t2 = parameters[offset++];
        } else {
            this.t1 = 0.0;
            this.t2 = 0.0;
        }
        this.skew = !this.zeroSkew ? parameters[offset++] : 0.0;
        if (!this.fixedMirror) {
            this.mirrorOffset = parameters[offset];
        }
    }

    @Override
    public void getIntrinsic(double[] parameters, int offset) {
        parameters[offset++] = this.fx;
        parameters[offset++] = this.fy;
        parameters[offset++] = this.cx;
        parameters[offset++] = this.cy;
        for (int i = 0; i < this.radial.length; ++i) {
            parameters[offset++] = this.radial[i];
        }
        if (this.tangential) {
            parameters[offset++] = this.t1;
            parameters[offset++] = this.t2;
        }
        if (!this.zeroSkew) {
            parameters[offset++] = this.skew;
        }
        if (!this.fixedMirror) {
            parameters[offset] = this.mirrorOffset;
        }
    }

    @Override
    public void project(double x, double y, double z, Point2D_F64 output) {
        double r2;
        double n = Math.sqrt(x * x + y * y + z * z);
        x /= n;
        y /= n;
        z /= n;
        double ri2 = r2 = (x /= (z += this.mirrorOffset)) * x + (y /= z) * y;
        double sum = 0.0;
        for (int i = 0; i < this.radial.length; ++i) {
            sum += this.radial[i] * ri2;
            ri2 *= r2;
        }
        double dx = x * (1.0 + sum) + 2.0 * this.t1 * x * y + this.t2 * (r2 + 2.0 * x * x);
        double dy = y * (1.0 + sum) + this.t1 * (r2 + 2.0 * y * y) + 2.0 * this.t2 * x * y;
        output.x = this.fx * dx + this.skew * dy + this.cx;
        output.y = this.fy * dy + this.cy;
    }

    @Override
    public void jacobian(double camX, double camY, double camZ, double[] inputX, double[] inputY, boolean computeIntrinsic, @Nullable double[] calibX, @Nullable double[] calibY) {
        double r2;
        double n2 = camX * camX + camY * camY + camZ * camZ;
        double n = Math.sqrt(n2);
        double X2 = camX / n;
        double Y2 = camY / n;
        double Z2 = camZ / n;
        this.jacSp.a11 = -camX * X2 / n2 + 1.0 / n;
        this.jacSp.a12 = -camY * X2 / n2;
        this.jacSp.a13 = -camZ * X2 / n2;
        this.jacSp.a21 = -camX * Y2 / n2;
        this.jacSp.a22 = -camY * Y2 / n2 + 1.0 / n;
        this.jacSp.a23 = -camZ * Y2 / n2;
        this.jacSp.a31 = -camX * Z2 / n2;
        this.jacSp.a32 = -camY * Z2 / n2;
        this.jacSp.a33 = -camZ * Z2 / n2 + 1.0 / n;
        double nx = X2 / (Z2 += this.mirrorOffset);
        double ny = Y2 / Z2;
        double sum = 0.0;
        double sumdot = 0.0;
        double r2i = r2 = nx * nx + ny * ny;
        double rdev = 1.0;
        for (int i = 0; i < this.radial.length; ++i) {
            sum += this.radial[i] * r2i;
            sumdot += this.radial[i] * (double)(i + 1) * rdev;
            r2i *= r2;
            rdev *= r2;
        }
        double xdot_X = sumdot * 2.0 * nx * nx / Z2 + (1.0 + sum) / Z2;
        double ydot_X = sumdot * 2.0 * nx * ny / Z2;
        if (this.tangential) {
            xdot_X += (2.0 * this.t1 * ny + this.t2 * 6.0 * nx) / Z2;
            ydot_X += (2.0 * this.t1 * nx + 2.0 * ny * this.t2) / Z2;
        }
        double xdot_Y = sumdot * 2.0 * ny * nx / Z2;
        double ydot_Y = sumdot * 2.0 * ny * ny / Z2 + (1.0 + sum) / Z2;
        if (this.tangential) {
            xdot_Y += (2.0 * this.t1 * nx + this.t2 * 2.0 * ny) / Z2;
            ydot_Y += (6.0 * this.t1 * ny + 2.0 * nx * this.t2) / Z2;
        }
        double xdot_Z = -sumdot * 2.0 * r2 * nx / Z2;
        double ydot_Z = -sumdot * 2.0 * r2 * ny / Z2;
        xdot_Z += -(1.0 + sum) * nx / Z2;
        ydot_Z += -(1.0 + sum) * ny / Z2;
        if (this.tangential) {
            xdot_Z += -(4.0 * this.t1 * nx * ny + 6.0 * this.t2 * nx * nx + 2.0 * this.t2 * ny * ny) / Z2;
            ydot_Z += -(2.0 * this.t1 * nx * nx + 6.0 * this.t1 * ny * ny + 4.0 * nx * ny * this.t2) / Z2;
        }
        double fooX = xdot_X * this.jacSp.a11 + xdot_Y * this.jacSp.a12 + xdot_Z * this.jacSp.a13;
        double fooY = ydot_X * this.jacSp.a11 + ydot_Y * this.jacSp.a12 + ydot_Z * this.jacSp.a13;
        inputX[0] = this.fx * fooX + this.skew * fooY;
        inputY[0] = this.fy * fooY;
        fooX = xdot_X * this.jacSp.a21 + xdot_Y * this.jacSp.a22 + xdot_Z * this.jacSp.a23;
        fooY = ydot_X * this.jacSp.a21 + ydot_Y * this.jacSp.a22 + ydot_Z * this.jacSp.a23;
        inputX[1] = this.fx * fooX + this.skew * fooY;
        inputY[1] = this.fy * fooY;
        fooX = xdot_X * this.jacSp.a31 + xdot_Y * this.jacSp.a32 + xdot_Z * this.jacSp.a33;
        fooY = ydot_X * this.jacSp.a31 + ydot_Y * this.jacSp.a32 + ydot_Z * this.jacSp.a33;
        inputX[2] = this.fx * fooX + this.skew * fooY;
        inputY[2] = this.fy * fooY;
        if (!computeIntrinsic) {
            return;
        }
        double dx = nx + nx * sum + (this.tangential ? 2.0 * this.t1 * nx * ny + this.t2 * (r2 + 2.0 * nx * nx) : 0.0);
        double dy = ny + ny * sum + (this.tangential ? this.t1 * (r2 + 2.0 * ny * ny) + 2.0 * this.t2 * ny * ny : 0.0);
        this.jacobianIntrinsic(calibX, calibY, Z2, nx, ny, dx, dy);
    }

    private void jacobianIntrinsic(double[] calibX, double[] calibY, double Z2, double nx, double ny, double dnx, double dny) {
        double r2;
        int index = 0;
        calibX[index] = dnx;
        calibY[index++] = 0.0;
        calibX[index] = 0.0;
        calibY[index++] = dny;
        calibX[index] = 1.0;
        calibY[index++] = 0.0;
        calibX[index] = 0.0;
        calibY[index++] = 1.0;
        double r2i = r2 = nx * nx + ny * ny;
        for (int i = 0; i < this.radial.length; ++i) {
            double xdot = nx * r2i;
            double ydot = ny * r2i;
            calibX[index] = this.fx * xdot + this.skew * ydot;
            calibY[index++] = this.fy * ydot;
            r2i *= r2;
        }
        if (this.tangential) {
            double xy2 = 2.0 * nx * ny;
            double r2yy = r2 + 2.0 * ny * ny;
            double r2xx = r2 + 2.0 * nx * nx;
            calibX[index] = this.fx * xy2 + this.skew * r2yy;
            calibY[index++] = this.fy * r2yy;
            calibX[index] = this.fx * r2xx + this.skew * xy2;
            calibY[index++] = this.fy * xy2;
        }
        if (!this.zeroSkew) {
            calibX[index] = dny;
            calibY[index++] = 0.0;
        }
        if (!this.fixedMirror) {
            double dri2 = -2.0 * r2 / Z2;
            double dsum = 0.0;
            double ri2 = r2;
            double sum = 0.0;
            for (int i = 0; i < this.radial.length; ++i) {
                sum += this.radial[i] * ri2;
                dsum += (double)(i + 1) * this.radial[i] * dri2;
                dri2 *= r2;
                ri2 *= r2;
            }
            double dx = -nx / Z2 * (1.0 + sum) + nx * dsum;
            double dy = -ny / Z2 * (1.0 + sum) + ny * dsum;
            if (this.tangential) {
                dx += -2.0 * (2.0 * this.t1 * nx * ny + this.t2 * (r2 + 2.0 * nx * nx)) / Z2;
                dy += -2.0 * (this.t1 * (r2 + 2.0 * ny * ny) + 2.0 * this.t2 * nx * ny) / Z2;
            }
            calibX[index] = this.fx * dx + this.skew * dy;
            calibY[index] = this.fy * dy;
        }
    }

    @Override
    public int getIntrinsicCount() {
        int totalIntrinsic = 4 + this.radial.length;
        if (this.tangential) {
            totalIntrinsic += 2;
        }
        if (!this.zeroSkew) {
            ++totalIntrinsic;
        }
        if (!this.fixedMirror) {
            ++totalIntrinsic;
        }
        return totalIntrinsic;
    }
}

